/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.services.qapps.model.DependencyListCopier;
import software.amazon.awssdk.services.qapps.model.PluginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QPluginCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QPluginCard> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(QPluginCard.getter(QPluginCard::id)).setter(QPluginCard.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(QPluginCard.getter(QPluginCard::title)).setter(QPluginCard.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(QPluginCard.getter(QPluginCard::dependencies)).setter(QPluginCard.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(QPluginCard.getter(QPluginCard::typeAsString)).setter(QPluginCard.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prompt").getter(QPluginCard.getter(QPluginCard::prompt)).setter(QPluginCard.setter(Builder::prompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()}).build();
    private static final SdkField<String> PLUGIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginType").getter(QPluginCard.getter(QPluginCard::pluginTypeAsString)).setter(QPluginCard.setter(Builder::pluginType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginType").build()}).build();
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(QPluginCard.getter(QPluginCard::pluginId)).setter(QPluginCard.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, DEPENDENCIES_FIELD, TYPE_FIELD, PROMPT_FIELD, PLUGIN_TYPE_FIELD, PLUGIN_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final List<String> dependencies;
    private final String type;
    private final String prompt;
    private final String pluginType;
    private final String pluginId;

    private QPluginCard(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.dependencies = builder.dependencies;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.pluginType = builder.pluginType;
        this.pluginId = builder.pluginId;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<String> dependencies() {
        return this.dependencies;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String prompt() {
        return this.prompt;
    }

    public final PluginType pluginType() {
        return PluginType.fromValue(this.pluginType);
    }

    public final String pluginTypeAsString() {
        return this.pluginType;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QPluginCard)) {
            return false;
        }
        QPluginCard other = (QPluginCard)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.pluginTypeAsString(), other.pluginTypeAsString()) && Objects.equals(this.pluginId(), other.pluginId());
    }

    public final String toString() {
        return ToString.builder((String)"QPluginCard").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).add("Type", (Object)this.typeAsString()).add("Prompt", (Object)this.prompt()).add("PluginType", (Object)this.pluginTypeAsString()).add("PluginId", (Object)this.pluginId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
            case "pluginType": {
                return Optional.ofNullable(clazz.cast(this.pluginTypeAsString()));
            }
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QPluginCard, T> g) {
        return obj -> g.apply((QPluginCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String prompt;
        private String pluginType;
        private String pluginId;

        private BuilderImpl() {
        }

        private BuilderImpl(QPluginCard model) {
            this.id(model.id);
            this.title(model.title);
            this.dependencies(model.dependencies);
            this.type(model.type);
            this.prompt(model.prompt);
            this.pluginType(model.pluginType);
            this.pluginId(model.pluginId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (this.dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return this.prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getPluginType() {
            return this.pluginType;
        }

        public final void setPluginType(String pluginType) {
            this.pluginType = pluginType;
        }

        @Override
        public final Builder pluginType(String pluginType) {
            this.pluginType = pluginType;
            return this;
        }

        @Override
        public final Builder pluginType(PluginType pluginType) {
            this.pluginType(pluginType == null ? null : pluginType.toString());
            return this;
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public QPluginCard build() {
            return new QPluginCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QPluginCard> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder dependencies(Collection<String> var1);

        public Builder dependencies(String ... var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder prompt(String var1);

        public Builder pluginType(String var1);

        public Builder pluginType(PluginType var1);

        public Builder pluginId(String var1);
    }
}

