/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.CardStatus;
import software.amazon.awssdk.services.qapps.model.CardStatusMapCopier;
import software.amazon.awssdk.services.qapps.model.ExecutionStatus;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQAppSessionResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, GetQAppSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::sessionId)).setter(GetQAppSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::sessionArn)).setter(GetQAppSessionResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::statusAsString)).setter(GetQAppSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, CardStatus>> CARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("cardStatus").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::cardStatus)).setter(GetQAppSessionResponse.setter(Builder::cardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardStatus").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CardStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, SESSION_ARN_FIELD, STATUS_FIELD, CARD_STATUS_FIELD));
    private final String sessionId;
    private final String sessionArn;
    private final String status;
    private final Map<String, CardStatus> cardStatus;

    private GetQAppSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.status = builder.status;
        this.cardStatus = builder.cardStatus;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasCardStatus() {
        return this.cardStatus != null && !(this.cardStatus instanceof SdkAutoConstructMap);
    }

    public final Map<String, CardStatus> cardStatus() {
        return this.cardStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCardStatus() ? this.cardStatus() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQAppSessionResponse)) {
            return false;
        }
        GetQAppSessionResponse other = (GetQAppSessionResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasCardStatus() == other.hasCardStatus() && Objects.equals(this.cardStatus(), other.cardStatus());
    }

    public final String toString() {
        return ToString.builder((String)"GetQAppSessionResponse").add("SessionId", (Object)this.sessionId()).add("SessionArn", (Object)this.sessionArn()).add("Status", (Object)this.statusAsString()).add("CardStatus", this.hasCardStatus() ? this.cardStatus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "cardStatus": {
                return Optional.ofNullable(clazz.cast(this.cardStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQAppSessionResponse, T> g) {
        return obj -> g.apply((GetQAppSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String sessionArn;
        private String status;
        private Map<String, CardStatus> cardStatus = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQAppSessionResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.sessionArn(model.sessionArn);
            this.status(model.status);
            this.cardStatus(model.cardStatus);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, CardStatus.Builder> getCardStatus() {
            Map<String, CardStatus.Builder> result = CardStatusMapCopier.copyToBuilder(this.cardStatus);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCardStatus(Map<String, CardStatus.BuilderImpl> cardStatus) {
            this.cardStatus = CardStatusMapCopier.copyFromBuilder(cardStatus);
        }

        @Override
        public final Builder cardStatus(Map<String, CardStatus> cardStatus) {
            this.cardStatus = CardStatusMapCopier.copy(cardStatus);
            return this;
        }

        @Override
        public GetQAppSessionResponse build() {
            return new GetQAppSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQAppSessionResponse> {
        public Builder sessionId(String var1);

        public Builder sessionArn(String var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder cardStatus(Map<String, CardStatus> var1);
    }
}

