/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.AppDefinitionInput;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.services.qapps.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQAppRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, CreateQAppRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(CreateQAppRequest.getter(CreateQAppRequest::instanceId)).setter(CreateQAppRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreateQAppRequest.getter(CreateQAppRequest::title)).setter(CreateQAppRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateQAppRequest.getter(CreateQAppRequest::description)).setter(CreateQAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AppDefinitionInput> APP_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appDefinition").getter(CreateQAppRequest.getter(CreateQAppRequest::appDefinition)).setter(CreateQAppRequest.setter(Builder::appDefinition)).constructor(AppDefinitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appDefinition").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateQAppRequest.getter(CreateQAppRequest::tags)).setter(CreateQAppRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, APP_DEFINITION_FIELD, TAGS_FIELD));
    private final String instanceId;
    private final String title;
    private final String description;
    private final AppDefinitionInput appDefinition;
    private final Map<String, String> tags;

    private CreateQAppRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.title = builder.title;
        this.description = builder.description;
        this.appDefinition = builder.appDefinition;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final AppDefinitionInput appDefinition() {
        return this.appDefinition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.appDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQAppRequest)) {
            return false;
        }
        CreateQAppRequest other = (CreateQAppRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.appDefinition(), other.appDefinition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQAppRequest").add("InstanceId", (Object)this.instanceId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("AppDefinition", (Object)this.appDefinition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "appDefinition": {
                return Optional.ofNullable(clazz.cast(this.appDefinition()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQAppRequest, T> g) {
        return obj -> g.apply((CreateQAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String title;
        private String description;
        private AppDefinitionInput appDefinition;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQAppRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.title(model.title);
            this.description(model.description);
            this.appDefinition(model.appDefinition);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AppDefinitionInput.Builder getAppDefinition() {
            return this.appDefinition != null ? this.appDefinition.toBuilder() : null;
        }

        public final void setAppDefinition(AppDefinitionInput.BuilderImpl appDefinition) {
            this.appDefinition = appDefinition != null ? appDefinition.build() : null;
        }

        @Override
        public final Builder appDefinition(AppDefinitionInput appDefinition) {
            this.appDefinition = appDefinition;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQAppRequest build() {
            return new CreateQAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQAppRequest> {
        public Builder instanceId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder appDefinition(AppDefinitionInput var1);

        default public Builder appDefinition(Consumer<AppDefinitionInput.Builder> appDefinition) {
            return this.appDefinition((AppDefinitionInput)((AppDefinitionInput.Builder)AppDefinitionInput.builder().applyMutation(appDefinition)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

