/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.Card;
import software.amazon.awssdk.services.qapps.model.CardModelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppDefinition> {
    private static final SdkField<String> APP_DEFINITION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appDefinitionVersion").getter(AppDefinition.getter(AppDefinition::appDefinitionVersion)).setter(AppDefinition.setter(Builder::appDefinitionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appDefinitionVersion").build()}).build();
    private static final SdkField<List<Card>> CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cards").getter(AppDefinition.getter(AppDefinition::cards)).setter(AppDefinition.setter(Builder::cards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Card::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CAN_EDIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canEdit").getter(AppDefinition.getter(AppDefinition::canEdit)).setter(AppDefinition.setter(Builder::canEdit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canEdit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_DEFINITION_VERSION_FIELD, CARDS_FIELD, CAN_EDIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appDefinitionVersion;
    private final List<Card> cards;
    private final Boolean canEdit;

    private AppDefinition(BuilderImpl builder) {
        this.appDefinitionVersion = builder.appDefinitionVersion;
        this.cards = builder.cards;
        this.canEdit = builder.canEdit;
    }

    public final String appDefinitionVersion() {
        return this.appDefinitionVersion;
    }

    public final boolean hasCards() {
        return this.cards != null && !(this.cards instanceof SdkAutoConstructList);
    }

    public final List<Card> cards() {
        return this.cards;
    }

    public final Boolean canEdit() {
        return this.canEdit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCards() ? this.cards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canEdit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppDefinition)) {
            return false;
        }
        AppDefinition other = (AppDefinition)obj;
        return Objects.equals(this.appDefinitionVersion(), other.appDefinitionVersion()) && this.hasCards() == other.hasCards() && Objects.equals(this.cards(), other.cards()) && Objects.equals(this.canEdit(), other.canEdit());
    }

    public final String toString() {
        return ToString.builder((String)"AppDefinition").add("AppDefinitionVersion", (Object)this.appDefinitionVersion()).add("Cards", this.hasCards() ? this.cards() : null).add("CanEdit", (Object)this.canEdit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appDefinitionVersion": {
                return Optional.ofNullable(clazz.cast(this.appDefinitionVersion()));
            }
            case "cards": {
                return Optional.ofNullable(clazz.cast(this.cards()));
            }
            case "canEdit": {
                return Optional.ofNullable(clazz.cast(this.canEdit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppDefinition, T> g) {
        return obj -> g.apply((AppDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appDefinitionVersion;
        private List<Card> cards = DefaultSdkAutoConstructList.getInstance();
        private Boolean canEdit;

        private BuilderImpl() {
        }

        private BuilderImpl(AppDefinition model) {
            this.appDefinitionVersion(model.appDefinitionVersion);
            this.cards(model.cards);
            this.canEdit(model.canEdit);
        }

        public final String getAppDefinitionVersion() {
            return this.appDefinitionVersion;
        }

        public final void setAppDefinitionVersion(String appDefinitionVersion) {
            this.appDefinitionVersion = appDefinitionVersion;
        }

        @Override
        public final Builder appDefinitionVersion(String appDefinitionVersion) {
            this.appDefinitionVersion = appDefinitionVersion;
            return this;
        }

        public final List<Card.Builder> getCards() {
            List<Card.Builder> result = CardModelListCopier.copyToBuilder(this.cards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCards(Collection<Card.BuilderImpl> cards) {
            this.cards = CardModelListCopier.copyFromBuilder(cards);
        }

        @Override
        public final Builder cards(Collection<Card> cards) {
            this.cards = CardModelListCopier.copy(cards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(Card ... cards) {
            this.cards(Arrays.asList(cards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cards(Consumer<Card.Builder> ... cards) {
            this.cards(Stream.of(cards).map(c -> (Card)((Card.Builder)Card.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCanEdit() {
            return this.canEdit;
        }

        public final void setCanEdit(Boolean canEdit) {
            this.canEdit = canEdit;
        }

        @Override
        public final Builder canEdit(Boolean canEdit) {
            this.canEdit = canEdit;
            return this;
        }

        public AppDefinition build() {
            return new AppDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppDefinition> {
        public Builder appDefinitionVersion(String var1);

        public Builder cards(Collection<Card> var1);

        public Builder cards(Card ... var1);

        public Builder cards(Consumer<Card.Builder> ... var1);

        public Builder canEdit(Boolean var1);
    }
}

