/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListServicePipelineProvisionedResourcesIterable
implements SdkIterable<ListServicePipelineProvisionedResourcesResponse> {
    private final ProtonClient client;
    private final ListServicePipelineProvisionedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicePipelineProvisionedResourcesIterable(ProtonClient client, ListServicePipelineProvisionedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServicePipelineProvisionedResourcesResponseFetcher();
    }

    public Iterator<ListServicePipelineProvisionedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisionedResource> provisionedResources() {
        Function<ListServicePipelineProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServicePipelineProvisionedResourcesResponseFetcher
    implements SyncPageFetcher<ListServicePipelineProvisionedResourcesResponse> {
        private ListServicePipelineProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicePipelineProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicePipelineProvisionedResourcesResponse nextPage(ListServicePipelineProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListServicePipelineProvisionedResourcesIterable.this.client.listServicePipelineProvisionedResources(ListServicePipelineProvisionedResourcesIterable.this.firstRequest);
            }
            return ListServicePipelineProvisionedResourcesIterable.this.client.listServicePipelineProvisionedResources((ListServicePipelineProvisionedResourcesRequest)((Object)ListServicePipelineProvisionedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

