/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTemplateSyncConfigRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, DeleteTemplateSyncConfigRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(DeleteTemplateSyncConfigRequest.getter(DeleteTemplateSyncConfigRequest::templateName)).setter(DeleteTemplateSyncConfigRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(DeleteTemplateSyncConfigRequest.getter(DeleteTemplateSyncConfigRequest::templateTypeAsString)).setter(DeleteTemplateSyncConfigRequest.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("templateName", TEMPLATE_NAME_FIELD);
            this.put("templateType", TEMPLATE_TYPE_FIELD);
        }
    });
    private final String templateName;
    private final String templateType;

    private DeleteTemplateSyncConfigRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTemplateSyncConfigRequest)) {
            return false;
        }
        DeleteTemplateSyncConfigRequest other = (DeleteTemplateSyncConfigRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTemplateSyncConfigRequest").add("TemplateName", (Object)this.templateName()).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTemplateSyncConfigRequest, T> g) {
        return obj -> g.apply((DeleteTemplateSyncConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTemplateSyncConfigRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.templateType(model.templateType);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTemplateSyncConfigRequest build() {
            return new DeleteTemplateSyncConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTemplateSyncConfigRequest> {
        public Builder templateName(String var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

