/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.proton.model.GetComponentRequest;
import software.amazon.awssdk.services.proton.model.GetComponentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.waiters.ProtonWaiter;
import software.amazon.awssdk.services.proton.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultProtonWaiter
implements ProtonWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final ProtonClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetComponentResponse> componentDeletedWaiter;
    private final Waiter<GetComponentResponse> componentDeployedWaiter;
    private final Waiter<GetEnvironmentResponse> environmentDeployedWaiter;
    private final Waiter<GetEnvironmentTemplateVersionResponse> environmentTemplateVersionRegisteredWaiter;
    private final Waiter<GetServiceResponse> serviceCreatedWaiter;
    private final Waiter<GetServiceResponse> serviceDeletedWaiter;
    private final Waiter<GetServiceInstanceResponse> serviceInstanceDeployedWaiter;
    private final Waiter<GetServiceResponse> servicePipelineDeployedWaiter;
    private final Waiter<GetServiceTemplateVersionResponse> serviceTemplateVersionRegisteredWaiter;
    private final Waiter<GetServiceResponse> serviceUpdatedWaiter;

    private DefaultProtonWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ProtonClient)ProtonClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.componentDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetComponentResponse.class).acceptors(DefaultProtonWaiter.componentDeletedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.componentDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.componentDeployedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetComponentResponse.class).acceptors(DefaultProtonWaiter.componentDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.componentDeployedWaiterConfig(builder.overrideConfiguration))).build();
        this.environmentDeployedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetEnvironmentResponse.class).acceptors(DefaultProtonWaiter.environmentDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.environmentDeployedWaiterConfig(builder.overrideConfiguration))).build();
        this.environmentTemplateVersionRegisteredWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetEnvironmentTemplateVersionResponse.class).acceptors(DefaultProtonWaiter.environmentTemplateVersionRegisteredWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.environmentTemplateVersionRegisteredWaiterConfig(builder.overrideConfiguration))).build();
        this.serviceCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetServiceResponse.class).acceptors(DefaultProtonWaiter.serviceCreatedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.serviceCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.serviceDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetServiceResponse.class).acceptors(DefaultProtonWaiter.serviceDeletedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.serviceDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.serviceInstanceDeployedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetServiceInstanceResponse.class).acceptors(DefaultProtonWaiter.serviceInstanceDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.serviceInstanceDeployedWaiterConfig(builder.overrideConfiguration))).build();
        this.servicePipelineDeployedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetServiceResponse.class).acceptors(DefaultProtonWaiter.servicePipelineDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.servicePipelineDeployedWaiterConfig(builder.overrideConfiguration))).build();
        this.serviceTemplateVersionRegisteredWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetServiceTemplateVersionResponse.class).acceptors(DefaultProtonWaiter.serviceTemplateVersionRegisteredWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.serviceTemplateVersionRegisteredWaiterConfig(builder.overrideConfiguration))).build();
        this.serviceUpdatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetServiceResponse.class).acceptors(DefaultProtonWaiter.serviceUpdatedWaiterAcceptors())).overrideConfiguration(DefaultProtonWaiter.serviceUpdatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetComponentResponse> waitUntilComponentDeleted(GetComponentRequest getComponentRequest) {
        return this.componentDeletedWaiter.run(() -> this.client.getComponent(this.applyWaitersUserAgent(getComponentRequest)));
    }

    @Override
    public WaiterResponse<GetComponentResponse> waitUntilComponentDeleted(GetComponentRequest getComponentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.componentDeletedWaiter.run(() -> this.client.getComponent(this.applyWaitersUserAgent(getComponentRequest)), DefaultProtonWaiter.componentDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetComponentResponse> waitUntilComponentDeployed(GetComponentRequest getComponentRequest) {
        return this.componentDeployedWaiter.run(() -> this.client.getComponent(this.applyWaitersUserAgent(getComponentRequest)));
    }

    @Override
    public WaiterResponse<GetComponentResponse> waitUntilComponentDeployed(GetComponentRequest getComponentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.componentDeployedWaiter.run(() -> this.client.getComponent(this.applyWaitersUserAgent(getComponentRequest)), DefaultProtonWaiter.componentDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetEnvironmentResponse> waitUntilEnvironmentDeployed(GetEnvironmentRequest getEnvironmentRequest) {
        return this.environmentDeployedWaiter.run(() -> this.client.getEnvironment(this.applyWaitersUserAgent(getEnvironmentRequest)));
    }

    @Override
    public WaiterResponse<GetEnvironmentResponse> waitUntilEnvironmentDeployed(GetEnvironmentRequest getEnvironmentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentDeployedWaiter.run(() -> this.client.getEnvironment(this.applyWaitersUserAgent(getEnvironmentRequest)), DefaultProtonWaiter.environmentDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetEnvironmentTemplateVersionResponse> waitUntilEnvironmentTemplateVersionRegistered(GetEnvironmentTemplateVersionRequest getEnvironmentTemplateVersionRequest) {
        return this.environmentTemplateVersionRegisteredWaiter.run(() -> this.client.getEnvironmentTemplateVersion(this.applyWaitersUserAgent(getEnvironmentTemplateVersionRequest)));
    }

    @Override
    public WaiterResponse<GetEnvironmentTemplateVersionResponse> waitUntilEnvironmentTemplateVersionRegistered(GetEnvironmentTemplateVersionRequest getEnvironmentTemplateVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentTemplateVersionRegisteredWaiter.run(() -> this.client.getEnvironmentTemplateVersion(this.applyWaitersUserAgent(getEnvironmentTemplateVersionRequest)), DefaultProtonWaiter.environmentTemplateVersionRegisteredWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServiceCreated(GetServiceRequest getServiceRequest) {
        return this.serviceCreatedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServiceCreated(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceCreatedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonWaiter.serviceCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServiceDeleted(GetServiceRequest getServiceRequest) {
        return this.serviceDeletedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServiceDeleted(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceDeletedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonWaiter.serviceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetServiceInstanceResponse> waitUntilServiceInstanceDeployed(GetServiceInstanceRequest getServiceInstanceRequest) {
        return this.serviceInstanceDeployedWaiter.run(() -> this.client.getServiceInstance(this.applyWaitersUserAgent(getServiceInstanceRequest)));
    }

    @Override
    public WaiterResponse<GetServiceInstanceResponse> waitUntilServiceInstanceDeployed(GetServiceInstanceRequest getServiceInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceInstanceDeployedWaiter.run(() -> this.client.getServiceInstance(this.applyWaitersUserAgent(getServiceInstanceRequest)), DefaultProtonWaiter.serviceInstanceDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServicePipelineDeployed(GetServiceRequest getServiceRequest) {
        return this.servicePipelineDeployedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServicePipelineDeployed(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.servicePipelineDeployedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonWaiter.servicePipelineDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetServiceTemplateVersionResponse> waitUntilServiceTemplateVersionRegistered(GetServiceTemplateVersionRequest getServiceTemplateVersionRequest) {
        return this.serviceTemplateVersionRegisteredWaiter.run(() -> this.client.getServiceTemplateVersion(this.applyWaitersUserAgent(getServiceTemplateVersionRequest)));
    }

    @Override
    public WaiterResponse<GetServiceTemplateVersionResponse> waitUntilServiceTemplateVersionRegistered(GetServiceTemplateVersionRequest getServiceTemplateVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceTemplateVersionRegisteredWaiter.run(() -> this.client.getServiceTemplateVersion(this.applyWaitersUserAgent(getServiceTemplateVersionRequest)), DefaultProtonWaiter.serviceTemplateVersionRegisteredWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServiceUpdated(GetServiceRequest getServiceRequest) {
        return this.serviceUpdatedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public WaiterResponse<GetServiceResponse> waitUntilServiceUpdated(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceUpdatedWaiter.run(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonWaiter.serviceUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetComponentResponse>> componentDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetComponentResponse>> result = new ArrayList<WaiterAcceptor<? super GetComponentResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultProtonWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("component").field("deploymentStatus").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (component.deploymentStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetComponentResponse>> componentDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetComponentResponse>> result = new ArrayList<WaiterAcceptor<? super GetComponentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("component").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("component").field("deploymentStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (component.deploymentStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetEnvironmentResponse>> environmentDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetEnvironmentResponse>> result = new ArrayList<WaiterAcceptor<? super GetEnvironmentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("environment").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("environment").field("deploymentStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (environment.deploymentStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetEnvironmentTemplateVersionResponse>> environmentTemplateVersionRegisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetEnvironmentTemplateVersionResponse>> result = new ArrayList<WaiterAcceptor<? super GetEnvironmentTemplateVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("environmentTemplateVersion").field("status").value(), "DRAFT");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("environmentTemplateVersion").field("status").value(), "PUBLISHED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("environmentTemplateVersion").field("status").value(), "REGISTRATION_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (environmentTemplateVersion.status=REGISTRATION_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> serviceCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "CREATE_FAILED_CLEANUP_COMPLETE");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=CREATE_FAILED_CLEANUP_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "CREATE_FAILED_CLEANUP_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=CREATE_FAILED_CLEANUP_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> serviceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultProtonWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceInstanceResponse>> serviceInstanceDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceInstanceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("serviceInstance").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("serviceInstance").field("deploymentStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (serviceInstance.deploymentStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> servicePipelineDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("pipeline").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("pipeline").field("deploymentStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.pipeline.deploymentStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceTemplateVersionResponse>> serviceTemplateVersionRegisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceTemplateVersionResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceTemplateVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("serviceTemplateVersion").field("status").value(), "DRAFT");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("serviceTemplateVersion").field("status").value(), "PUBLISHED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("serviceTemplateVersion").field("status").value(), "REGISTRATION_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (serviceTemplateVersion.status=REGISTRATION_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> serviceUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_FAILED_CLEANUP_COMPLETE");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=UPDATE_FAILED_CLEANUP_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_FAILED_CLEANUP_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=UPDATE_FAILED_CLEANUP_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_COMPLETE_CLEANUP_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (service.status=UPDATE_COMPLETE_CLEANUP_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration componentDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration componentDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentTemplateVersionRegisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceInstanceDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration servicePipelineDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceTemplateVersionRegisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ProtonWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ProtonRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ProtonRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ProtonWaiter.Builder {
        private ProtonClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public ProtonWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ProtonWaiter.Builder client(ProtonClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ProtonWaiter build() {
            return new DefaultProtonWaiter(this);
        }
    }
}

