/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListEnvironmentOutputsIterable
implements SdkIterable<ListEnvironmentOutputsResponse> {
    private final ProtonClient client;
    private final ListEnvironmentOutputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentOutputsIterable(ProtonClient client, ListEnvironmentOutputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentOutputsResponseFetcher();
    }

    public Iterator<ListEnvironmentOutputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Output> outputs() {
        Function<ListEnvironmentOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentOutputsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentOutputsResponse> {
        private ListEnvironmentOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentOutputsResponse nextPage(ListEnvironmentOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentOutputsIterable.this.client.listEnvironmentOutputs(ListEnvironmentOutputsIterable.this.firstRequest);
            }
            return ListEnvironmentOutputsIterable.this.client.listEnvironmentOutputs((ListEnvironmentOutputsRequest)((Object)ListEnvironmentOutputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

