/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary;
import software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummaryListCopier;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentTemplatesResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListEnvironmentTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentTemplatesResponse.getter(ListEnvironmentTemplatesResponse::nextToken)).setter(ListEnvironmentTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<EnvironmentTemplateSummary>> TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templates").getter(ListEnvironmentTemplatesResponse.getter(ListEnvironmentTemplatesResponse::templates)).setter(ListEnvironmentTemplatesResponse.setter(Builder::templates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEMPLATES_FIELD));
    private final String nextToken;
    private final List<EnvironmentTemplateSummary> templates;

    private ListEnvironmentTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templates = builder.templates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTemplates() {
        return this.templates != null && !(this.templates instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentTemplateSummary> templates() {
        return this.templates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplates() ? this.templates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentTemplatesResponse)) {
            return false;
        }
        ListEnvironmentTemplatesResponse other = (ListEnvironmentTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTemplates() == other.hasTemplates() && Objects.equals(this.templates(), other.templates());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("Templates", this.hasTemplates() ? this.templates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templates": {
                return Optional.ofNullable(clazz.cast(this.templates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentTemplatesResponse, T> g) {
        return obj -> g.apply((ListEnvironmentTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EnvironmentTemplateSummary> templates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.templates(model.templates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EnvironmentTemplateSummary.Builder> getTemplates() {
            List<EnvironmentTemplateSummary.Builder> result = EnvironmentTemplateSummaryListCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<EnvironmentTemplateSummary.BuilderImpl> templates) {
            this.templates = EnvironmentTemplateSummaryListCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<EnvironmentTemplateSummary> templates) {
            this.templates = EnvironmentTemplateSummaryListCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(EnvironmentTemplateSummary ... templates) {
            this.templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<EnvironmentTemplateSummary.Builder> ... templates) {
            this.templates(Stream.of(templates).map(c -> (EnvironmentTemplateSummary)((EnvironmentTemplateSummary.Builder)EnvironmentTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEnvironmentTemplatesResponse build() {
            return new ListEnvironmentTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder templates(Collection<EnvironmentTemplateSummary> var1);

        public Builder templates(EnvironmentTemplateSummary ... var1);

        public Builder templates(Consumer<EnvironmentTemplateSummary.Builder> ... var1);
    }
}

