/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListServiceInstanceOutputsPublisher
implements SdkPublisher<ListServiceInstanceOutputsResponse> {
    private final ProtonAsyncClient client;
    private final ListServiceInstanceOutputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceInstanceOutputsPublisher(ProtonAsyncClient client, ListServiceInstanceOutputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceInstanceOutputsPublisher(ProtonAsyncClient client, ListServiceInstanceOutputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceInstanceOutputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceInstanceOutputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Output> outputs() {
        Function<ListServiceInstanceOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceInstanceOutputsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceInstanceOutputsResponseFetcher
    implements AsyncPageFetcher<ListServiceInstanceOutputsResponse> {
        private ListServiceInstanceOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceInstanceOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceInstanceOutputsResponse> nextPage(ListServiceInstanceOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceInstanceOutputsPublisher.this.client.listServiceInstanceOutputs(ListServiceInstanceOutputsPublisher.this.firstRequest);
            }
            return ListServiceInstanceOutputsPublisher.this.client.listServiceInstanceOutputs((ListServiceInstanceOutputsRequest)((Object)ListServiceInstanceOutputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

