/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListEnvironmentProvisionedResourcesIterable
implements SdkIterable<ListEnvironmentProvisionedResourcesResponse> {
    private final ProtonClient client;
    private final ListEnvironmentProvisionedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentProvisionedResourcesIterable(ProtonClient client, ListEnvironmentProvisionedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentProvisionedResourcesResponseFetcher();
    }

    public Iterator<ListEnvironmentProvisionedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisionedResource> provisionedResources() {
        Function<ListEnvironmentProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentProvisionedResourcesResponseFetcher
    implements SyncPageFetcher<ListEnvironmentProvisionedResourcesResponse> {
        private ListEnvironmentProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentProvisionedResourcesResponse nextPage(ListEnvironmentProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentProvisionedResourcesIterable.this.client.listEnvironmentProvisionedResources(ListEnvironmentProvisionedResourcesIterable.this.firstRequest);
            }
            return ListEnvironmentProvisionedResourcesIterable.this.client.listEnvironmentProvisionedResources((ListEnvironmentProvisionedResourcesRequest)((Object)ListEnvironmentProvisionedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

