/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.Tag;
import software.amazon.awssdk.services.proton.model.TagListCopier;
import software.amazon.awssdk.services.proton.model.TemplateVersionSourceInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentTemplateVersionRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentTemplateVersionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateEnvironmentTemplateVersionRequest.getter(CreateEnvironmentTemplateVersionRequest::clientToken)).setter(CreateEnvironmentTemplateVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEnvironmentTemplateVersionRequest.getter(CreateEnvironmentTemplateVersionRequest::description)).setter(CreateEnvironmentTemplateVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersion").getter(CreateEnvironmentTemplateVersionRequest.getter(CreateEnvironmentTemplateVersionRequest::majorVersion)).setter(CreateEnvironmentTemplateVersionRequest.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()}).build();
    private static final SdkField<TemplateVersionSourceInput> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateEnvironmentTemplateVersionRequest.getter(CreateEnvironmentTemplateVersionRequest::source)).setter(CreateEnvironmentTemplateVersionRequest.setter(Builder::source)).constructor(TemplateVersionSourceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateEnvironmentTemplateVersionRequest.getter(CreateEnvironmentTemplateVersionRequest::tags)).setter(CreateEnvironmentTemplateVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(CreateEnvironmentTemplateVersionRequest.getter(CreateEnvironmentTemplateVersionRequest::templateName)).setter(CreateEnvironmentTemplateVersionRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, MAJOR_VERSION_FIELD, SOURCE_FIELD, TAGS_FIELD, TEMPLATE_NAME_FIELD));
    private final String clientToken;
    private final String description;
    private final String majorVersion;
    private final TemplateVersionSourceInput source;
    private final List<Tag> tags;
    private final String templateName;

    private CreateEnvironmentTemplateVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.majorVersion = builder.majorVersion;
        this.source = builder.source;
        this.tags = builder.tags;
        this.templateName = builder.templateName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String majorVersion() {
        return this.majorVersion;
    }

    public final TemplateVersionSourceInput source() {
        return this.source;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentTemplateVersionRequest)) {
            return false;
        }
        CreateEnvironmentTemplateVersionRequest other = (CreateEnvironmentTemplateVersionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.majorVersion(), other.majorVersion()) && Objects.equals(this.source(), other.source()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentTemplateVersionRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("MajorVersion", (Object)this.majorVersion()).add("Source", (Object)this.source()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "majorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentTemplateVersionRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentTemplateVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String majorVersion;
        private TemplateVersionSourceInput source;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentTemplateVersionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.majorVersion(model.majorVersion);
            this.source(model.source);
            this.tags(model.tags);
            this.templateName(model.templateName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMajorVersion() {
            return this.majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final TemplateVersionSourceInput.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TemplateVersionSourceInput.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TemplateVersionSourceInput source) {
            this.source = source;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentTemplateVersionRequest build() {
            return new CreateEnvironmentTemplateVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentTemplateVersionRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder majorVersion(String var1);

        public Builder source(TemplateVersionSourceInput var1);

        default public Builder source(Consumer<TemplateVersionSourceInput.Builder> source) {
            return this.source((TemplateVersionSourceInput)((TemplateVersionSourceInput.Builder)TemplateVersionSourceInput.builder().applyMutation(source)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

