/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListComponentProvisionedResourcesPublisher
implements SdkPublisher<ListComponentProvisionedResourcesResponse> {
    private final ProtonAsyncClient client;
    private final ListComponentProvisionedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComponentProvisionedResourcesPublisher(ProtonAsyncClient client, ListComponentProvisionedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComponentProvisionedResourcesPublisher(ProtonAsyncClient client, ListComponentProvisionedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComponentProvisionedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComponentProvisionedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisionedResource> provisionedResources() {
        Function<ListComponentProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComponentProvisionedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComponentProvisionedResourcesResponseFetcher
    implements AsyncPageFetcher<ListComponentProvisionedResourcesResponse> {
        private ListComponentProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComponentProvisionedResourcesResponse> nextPage(ListComponentProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListComponentProvisionedResourcesPublisher.this.client.listComponentProvisionedResources(ListComponentProvisionedResourcesPublisher.this.firstRequest);
            }
            return ListComponentProvisionedResourcesPublisher.this.client.listComponentProvisionedResources((ListComponentProvisionedResourcesRequest)((Object)ListComponentProvisionedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

