/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServicePipelineProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListServicePipelineProvisionedResourcesPublisher
implements SdkPublisher<ListServicePipelineProvisionedResourcesResponse> {
    private final ProtonAsyncClient client;
    private final ListServicePipelineProvisionedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicePipelineProvisionedResourcesPublisher(ProtonAsyncClient client, ListServicePipelineProvisionedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicePipelineProvisionedResourcesPublisher(ProtonAsyncClient client, ListServicePipelineProvisionedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicePipelineProvisionedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicePipelineProvisionedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisionedResource> provisionedResources() {
        Function<ListServicePipelineProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServicePipelineProvisionedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServicePipelineProvisionedResourcesResponseFetcher
    implements AsyncPageFetcher<ListServicePipelineProvisionedResourcesResponse> {
        private ListServicePipelineProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicePipelineProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicePipelineProvisionedResourcesResponse> nextPage(ListServicePipelineProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListServicePipelineProvisionedResourcesPublisher.this.client.listServicePipelineProvisionedResources(ListServicePipelineProvisionedResourcesPublisher.this.firstRequest);
            }
            return ListServicePipelineProvisionedResourcesPublisher.this.client.listServicePipelineProvisionedResources((ListServicePipelineProvisionedResourcesRequest)((Object)ListServicePipelineProvisionedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

