/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class JsonValuesOperationRequest extends ProtocolRestJsonRequest implements
        ToCopyableBuilder<JsonValuesOperationRequest.Builder, JsonValuesOperationRequest> {
    private final String jsonValueHeaderMember;

    private final String jsonValueMember;

    private JsonValuesOperationRequest(BuilderImpl builder) {
        super(builder);
        this.jsonValueHeaderMember = builder.jsonValueHeaderMember;
        this.jsonValueMember = builder.jsonValueMember;
    }

    /**
     * Returns the value of the JsonValueHeaderMember property for this object.
     * 
     * @return The value of the JsonValueHeaderMember property for this object.
     */
    public String jsonValueHeaderMember() {
        return jsonValueHeaderMember;
    }

    /**
     * Returns the value of the JsonValueMember property for this object.
     * 
     * @return The value of the JsonValueMember property for this object.
     */
    public String jsonValueMember() {
        return jsonValueMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonValueHeaderMember());
        hashCode = 31 * hashCode + Objects.hashCode(jsonValueMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonValuesOperationRequest)) {
            return false;
        }
        JsonValuesOperationRequest other = (JsonValuesOperationRequest) obj;
        return Objects.equals(jsonValueHeaderMember(), other.jsonValueHeaderMember())
                && Objects.equals(jsonValueMember(), other.jsonValueMember());
    }

    @Override
    public String toString() {
        return ToString.builder("JsonValuesOperationRequest").add("JsonValueHeaderMember", jsonValueHeaderMember())
                .add("JsonValueMember", jsonValueMember()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JsonValueHeaderMember":
            return Optional.ofNullable(clazz.cast(jsonValueHeaderMember()));
        case "JsonValueMember":
            return Optional.ofNullable(clazz.cast(jsonValueMember()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestJsonRequest.Builder, CopyableBuilder<Builder, JsonValuesOperationRequest> {
        /**
         * Sets the value of the JsonValueHeaderMember property for this object.
         *
         * @param jsonValueHeaderMember
         *        The new value for the JsonValueHeaderMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonValueHeaderMember(String jsonValueHeaderMember);

        /**
         * Sets the value of the JsonValueMember property for this object.
         *
         * @param jsonValueMember
         *        The new value for the JsonValueMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonValueMember(String jsonValueMember);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolRestJsonRequest.BuilderImpl implements Builder {
        private String jsonValueHeaderMember;

        private String jsonValueMember;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonValuesOperationRequest model) {
            super(model);
            jsonValueHeaderMember(model.jsonValueHeaderMember);
            jsonValueMember(model.jsonValueMember);
        }

        public final String getJsonValueHeaderMember() {
            return jsonValueHeaderMember;
        }

        @Override
        public final Builder jsonValueHeaderMember(String jsonValueHeaderMember) {
            this.jsonValueHeaderMember = jsonValueHeaderMember;
            return this;
        }

        public final void setJsonValueHeaderMember(String jsonValueHeaderMember) {
            this.jsonValueHeaderMember = jsonValueHeaderMember;
        }

        public final String getJsonValueMember() {
            return jsonValueMember;
        }

        @Override
        public final Builder jsonValueMember(String jsonValueMember) {
            this.jsonValueMember = jsonValueMember;
            return this;
        }

        public final void setJsonValueMember(String jsonValueMember) {
            this.jsonValueMember = jsonValueMember;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public JsonValuesOperationRequest build() {
            return new JsonValuesOperationRequest(this);
        }
    }
}
