/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Ec2TypesRequest extends ProtocolEc2Request implements ToCopyableBuilder<Ec2TypesRequest.Builder, Ec2TypesRequest> {
    private final List<String> flattenedListOfStrings;

    private final List<SimpleStruct> flattenedListOfStructs;

    private final List<String> flattenedListWithLocation;

    private final String stringMemberWithLocation;

    private final String stringMemberWithQueryName;

    private final String stringMemberWithLocationAndQueryName;

    private final List<String> listMemberWithLocationAndQueryName;

    private final List<String> listMemberWithOnlyMemberLocation;

    private Ec2TypesRequest(BuilderImpl builder) {
        super(builder);
        this.flattenedListOfStrings = builder.flattenedListOfStrings;
        this.flattenedListOfStructs = builder.flattenedListOfStructs;
        this.flattenedListWithLocation = builder.flattenedListWithLocation;
        this.stringMemberWithLocation = builder.stringMemberWithLocation;
        this.stringMemberWithQueryName = builder.stringMemberWithQueryName;
        this.stringMemberWithLocationAndQueryName = builder.stringMemberWithLocationAndQueryName;
        this.listMemberWithLocationAndQueryName = builder.listMemberWithLocationAndQueryName;
        this.listMemberWithOnlyMemberLocation = builder.listMemberWithOnlyMemberLocation;
    }

    /**
     * Returns the value of the FlattenedListOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStrings property for this object.
     */
    public List<String> flattenedListOfStrings() {
        return flattenedListOfStrings;
    }

    /**
     * Returns the value of the FlattenedListOfStructs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStructs property for this object.
     */
    public List<SimpleStruct> flattenedListOfStructs() {
        return flattenedListOfStructs;
    }

    /**
     * Returns the value of the FlattenedListWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListWithLocation property for this object.
     */
    public List<String> flattenedListWithLocation() {
        return flattenedListWithLocation;
    }

    /**
     * Returns the value of the StringMemberWithLocation property for this object.
     * 
     * @return The value of the StringMemberWithLocation property for this object.
     */
    public String stringMemberWithLocation() {
        return stringMemberWithLocation;
    }

    /**
     * Returns the value of the StringMemberWithQueryName property for this object.
     * 
     * @return The value of the StringMemberWithQueryName property for this object.
     */
    public String stringMemberWithQueryName() {
        return stringMemberWithQueryName;
    }

    /**
     * Returns the value of the StringMemberWithLocationAndQueryName property for this object.
     * 
     * @return The value of the StringMemberWithLocationAndQueryName property for this object.
     */
    public String stringMemberWithLocationAndQueryName() {
        return stringMemberWithLocationAndQueryName;
    }

    /**
     * Returns the value of the ListMemberWithLocationAndQueryName property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListMemberWithLocationAndQueryName property for this object.
     */
    public List<String> listMemberWithLocationAndQueryName() {
        return listMemberWithLocationAndQueryName;
    }

    /**
     * Returns the value of the ListMemberWithOnlyMemberLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListMemberWithOnlyMemberLocation property for this object.
     */
    public List<String> listMemberWithOnlyMemberLocation() {
        return listMemberWithOnlyMemberLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flattenedListOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedListOfStructs());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedListWithLocation());
        hashCode = 31 * hashCode + Objects.hashCode(stringMemberWithLocation());
        hashCode = 31 * hashCode + Objects.hashCode(stringMemberWithQueryName());
        hashCode = 31 * hashCode + Objects.hashCode(stringMemberWithLocationAndQueryName());
        hashCode = 31 * hashCode + Objects.hashCode(listMemberWithLocationAndQueryName());
        hashCode = 31 * hashCode + Objects.hashCode(listMemberWithOnlyMemberLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2TypesRequest)) {
            return false;
        }
        Ec2TypesRequest other = (Ec2TypesRequest) obj;
        return Objects.equals(flattenedListOfStrings(), other.flattenedListOfStrings())
                && Objects.equals(flattenedListOfStructs(), other.flattenedListOfStructs())
                && Objects.equals(flattenedListWithLocation(), other.flattenedListWithLocation())
                && Objects.equals(stringMemberWithLocation(), other.stringMemberWithLocation())
                && Objects.equals(stringMemberWithQueryName(), other.stringMemberWithQueryName())
                && Objects.equals(stringMemberWithLocationAndQueryName(), other.stringMemberWithLocationAndQueryName())
                && Objects.equals(listMemberWithLocationAndQueryName(), other.listMemberWithLocationAndQueryName())
                && Objects.equals(listMemberWithOnlyMemberLocation(), other.listMemberWithOnlyMemberLocation());
    }

    @Override
    public String toString() {
        return ToString.builder("Ec2TypesRequest").add("FlattenedListOfStrings", flattenedListOfStrings())
                .add("FlattenedListOfStructs", flattenedListOfStructs())
                .add("FlattenedListWithLocation", flattenedListWithLocation())
                .add("StringMemberWithLocation", stringMemberWithLocation())
                .add("StringMemberWithQueryName", stringMemberWithQueryName())
                .add("StringMemberWithLocationAndQueryName", stringMemberWithLocationAndQueryName())
                .add("ListMemberWithLocationAndQueryName", listMemberWithLocationAndQueryName())
                .add("ListMemberWithOnlyMemberLocation", listMemberWithOnlyMemberLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlattenedListOfStrings":
            return Optional.of(clazz.cast(flattenedListOfStrings()));
        case "FlattenedListOfStructs":
            return Optional.of(clazz.cast(flattenedListOfStructs()));
        case "FlattenedListWithLocation":
            return Optional.of(clazz.cast(flattenedListWithLocation()));
        case "StringMemberWithLocation":
            return Optional.of(clazz.cast(stringMemberWithLocation()));
        case "StringMemberWithQueryName":
            return Optional.of(clazz.cast(stringMemberWithQueryName()));
        case "StringMemberWithLocationAndQueryName":
            return Optional.of(clazz.cast(stringMemberWithLocationAndQueryName()));
        case "ListMemberWithLocationAndQueryName":
            return Optional.of(clazz.cast(listMemberWithLocationAndQueryName()));
        case "ListMemberWithOnlyMemberLocation":
            return Optional.of(clazz.cast(listMemberWithOnlyMemberLocation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolEc2Request.Builder, CopyableBuilder<Builder, Ec2TypesRequest> {
        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings);

        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(String... flattenedListOfStrings);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(String... flattenedListWithLocation);

        /**
         * Sets the value of the StringMemberWithLocation property for this object.
         *
         * @param stringMemberWithLocation
         *        The new value for the StringMemberWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithLocation(String stringMemberWithLocation);

        /**
         * Sets the value of the StringMemberWithQueryName property for this object.
         *
         * @param stringMemberWithQueryName
         *        The new value for the StringMemberWithQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithQueryName(String stringMemberWithQueryName);

        /**
         * Sets the value of the StringMemberWithLocationAndQueryName property for this object.
         *
         * @param stringMemberWithLocationAndQueryName
         *        The new value for the StringMemberWithLocationAndQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName);

        /**
         * Sets the value of the ListMemberWithLocationAndQueryName property for this object.
         *
         * @param listMemberWithLocationAndQueryName
         *        The new value for the ListMemberWithLocationAndQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName);

        /**
         * Sets the value of the ListMemberWithLocationAndQueryName property for this object.
         *
         * @param listMemberWithLocationAndQueryName
         *        The new value for the ListMemberWithLocationAndQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName);

        /**
         * Sets the value of the ListMemberWithOnlyMemberLocation property for this object.
         *
         * @param listMemberWithOnlyMemberLocation
         *        The new value for the ListMemberWithOnlyMemberLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation);

        /**
         * Sets the value of the ListMemberWithOnlyMemberLocation property for this object.
         *
         * @param listMemberWithOnlyMemberLocation
         *        The new value for the ListMemberWithOnlyMemberLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ProtocolEc2Request.BuilderImpl implements Builder {
        private List<String> flattenedListOfStrings;

        private List<SimpleStruct> flattenedListOfStructs;

        private List<String> flattenedListWithLocation;

        private String stringMemberWithLocation;

        private String stringMemberWithQueryName;

        private String stringMemberWithLocationAndQueryName;

        private List<String> listMemberWithLocationAndQueryName;

        private List<String> listMemberWithOnlyMemberLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2TypesRequest model) {
            flattenedListOfStrings(model.flattenedListOfStrings);
            flattenedListOfStructs(model.flattenedListOfStructs);
            flattenedListWithLocation(model.flattenedListWithLocation);
            stringMemberWithLocation(model.stringMemberWithLocation);
            stringMemberWithQueryName(model.stringMemberWithQueryName);
            stringMemberWithLocationAndQueryName(model.stringMemberWithLocationAndQueryName);
            listMemberWithLocationAndQueryName(model.listMemberWithLocationAndQueryName);
            listMemberWithOnlyMemberLocation(model.listMemberWithOnlyMemberLocation);
        }

        public final Collection<String> getFlattenedListOfStrings() {
            return flattenedListOfStrings;
        }

        @Override
        public final Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStrings(String... flattenedListOfStrings) {
            flattenedListOfStrings(Arrays.asList(flattenedListOfStrings));
            return this;
        }

        public final void setFlattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
        }

        public final Collection<SimpleStruct.Builder> getFlattenedListOfStructs() {
            return flattenedListOfStructs != null ? flattenedListOfStructs.stream().map(SimpleStruct::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            flattenedListOfStructs(Arrays.asList(flattenedListOfStructs));
            return this;
        }

        public final void setFlattenedListOfStructs(Collection<SimpleStruct.BuilderImpl> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copyFromBuilder(flattenedListOfStructs);
        }

        public final Collection<String> getFlattenedListWithLocation() {
            return flattenedListWithLocation;
        }

        @Override
        public final Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListWithLocation(String... flattenedListWithLocation) {
            flattenedListWithLocation(Arrays.asList(flattenedListWithLocation));
            return this;
        }

        public final void setFlattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
        }

        public final String getStringMemberWithLocation() {
            return stringMemberWithLocation;
        }

        @Override
        public final Builder stringMemberWithLocation(String stringMemberWithLocation) {
            this.stringMemberWithLocation = stringMemberWithLocation;
            return this;
        }

        public final void setStringMemberWithLocation(String stringMemberWithLocation) {
            this.stringMemberWithLocation = stringMemberWithLocation;
        }

        public final String getStringMemberWithQueryName() {
            return stringMemberWithQueryName;
        }

        @Override
        public final Builder stringMemberWithQueryName(String stringMemberWithQueryName) {
            this.stringMemberWithQueryName = stringMemberWithQueryName;
            return this;
        }

        public final void setStringMemberWithQueryName(String stringMemberWithQueryName) {
            this.stringMemberWithQueryName = stringMemberWithQueryName;
        }

        public final String getStringMemberWithLocationAndQueryName() {
            return stringMemberWithLocationAndQueryName;
        }

        @Override
        public final Builder stringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName) {
            this.stringMemberWithLocationAndQueryName = stringMemberWithLocationAndQueryName;
            return this;
        }

        public final void setStringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName) {
            this.stringMemberWithLocationAndQueryName = stringMemberWithLocationAndQueryName;
        }

        public final Collection<String> getListMemberWithLocationAndQueryName() {
            return listMemberWithLocationAndQueryName;
        }

        @Override
        public final Builder listMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName) {
            this.listMemberWithLocationAndQueryName = ListOfStringsCopier.copy(listMemberWithLocationAndQueryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName) {
            listMemberWithLocationAndQueryName(Arrays.asList(listMemberWithLocationAndQueryName));
            return this;
        }

        public final void setListMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName) {
            this.listMemberWithLocationAndQueryName = ListOfStringsCopier.copy(listMemberWithLocationAndQueryName);
        }

        public final Collection<String> getListMemberWithOnlyMemberLocation() {
            return listMemberWithOnlyMemberLocation;
        }

        @Override
        public final Builder listMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation) {
            this.listMemberWithOnlyMemberLocation = ListOfStringsCopier.copy(listMemberWithOnlyMemberLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation) {
            listMemberWithOnlyMemberLocation(Arrays.asList(listMemberWithOnlyMemberLocation));
            return this;
        }

        public final void setListMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation) {
            this.listMemberWithOnlyMemberLocation = ListOfStringsCopier.copy(listMemberWithOnlyMemberLocation);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public Ec2TypesRequest build() {
            return new Ec2TypesRequest(this);
        }
    }
}
