/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestxml.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestxml.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestxml.model.ProtocolRestXmlException;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestxml.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesRequest;
import software.amazon.awssdk.services.protocolrestxml.model.RestXmlTypesResponse;
import software.amazon.awssdk.services.protocolrestxml.transform.AllTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.AllTypesResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.DeleteOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.DeleteOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.EmptyModeledExceptionUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.IdempotentOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.IdempotentOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MapOfStringToListOfStringInQueryParamsRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MapOfStringToListOfStringInQueryParamsResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInHeadersRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInHeadersResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInQueryParamsRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MembersInQueryParamsResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MultiLocationOperationRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.MultiLocationOperationResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithExplicitPayloadBlobRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithExplicitPayloadBlobResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithGreedyLabelRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithGreedyLabelResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithModeledContentTypeRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.OperationWithModeledContentTypeResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.QueryParamWithoutValueRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.QueryParamWithoutValueResponseUnmarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.RestXmlTypesRequestMarshaller;
import software.amazon.awssdk.services.protocolrestxml.transform.RestXmlTypesResponseUnmarshaller;

/**
 * Internal implementation of {@link ProtocolRestXmlClient}.
 *
 * @see ProtocolRestXmlClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultProtocolRestXmlClient implements ProtocolRestXmlClient {
    private final ClientHandler clientHandler;

    private final List<Unmarshaller<SdkServiceException, Node>> exceptionUnmarshallers;

    private final ClientConfiguration clientConfiguration;

    protected DefaultProtocolRestXmlClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = init();
        this.clientConfiguration = clientConfiguration;
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.AllTypes
     */
    @Override
    public AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, SdkServiceException,
            SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<AllTypesResponse> responseHandler = new StaxResponseHandler<AllTypesResponse>(
                new AllTypesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AllTypesRequest, AllTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(allTypesRequest)
                .withMarshaller(new AllTypesRequestMarshaller()));
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.DeleteOperation
     */
    @Override
    public DeleteOperationResponse deleteOperation(DeleteOperationRequest deleteOperationRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<DeleteOperationResponse> responseHandler = new StaxResponseHandler<DeleteOperationResponse>(
                new DeleteOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteOperationRequest, DeleteOperationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteOperationRequest).withMarshaller(new DeleteOperationRequestMarshaller()));
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.IdempotentOperation
     */
    @Override
    public IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<IdempotentOperationResponse> responseHandler = new StaxResponseHandler<IdempotentOperationResponse>(
                new IdempotentOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<IdempotentOperationRequest, IdempotentOperationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(idempotentOperationRequest).withMarshaller(new IdempotentOperationRequestMarshaller()));
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MapOfStringToListOfStringInQueryParams
     */
    @Override
    public MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<MapOfStringToListOfStringInQueryParamsResponse> responseHandler = new StaxResponseHandler<MapOfStringToListOfStringInQueryParamsResponse>(
                new MapOfStringToListOfStringInQueryParamsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<MapOfStringToListOfStringInQueryParamsRequest, MapOfStringToListOfStringInQueryParamsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(mapOfStringToListOfStringInQueryParamsRequest)
                        .withMarshaller(new MapOfStringToListOfStringInQueryParamsRequestMarshaller()));
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInHeaders
     */
    @Override
    public MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<MembersInHeadersResponse> responseHandler = new StaxResponseHandler<MembersInHeadersResponse>(
                new MembersInHeadersResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MembersInHeadersRequest, MembersInHeadersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(membersInHeadersRequest).withMarshaller(new MembersInHeadersRequestMarshaller()));
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MembersInQueryParams
     */
    @Override
    public MembersInQueryParamsResponse membersInQueryParams(MembersInQueryParamsRequest membersInQueryParamsRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<MembersInQueryParamsResponse> responseHandler = new StaxResponseHandler<MembersInQueryParamsResponse>(
                new MembersInQueryParamsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MembersInQueryParamsRequest, MembersInQueryParamsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(membersInQueryParamsRequest).withMarshaller(new MembersInQueryParamsRequestMarshaller()));
    }

    /**
     * Invokes the MultiLocationOperation operation.
     *
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.MultiLocationOperation
     */
    @Override
    public MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<MultiLocationOperationResponse> responseHandler = new StaxResponseHandler<MultiLocationOperationResponse>(
                new MultiLocationOperationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MultiLocationOperationRequest, MultiLocationOperationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(multiLocationOperationRequest).withMarshaller(new MultiLocationOperationRequestMarshaller()));
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithExplicitPayloadBlob
     */
    @Override
    public OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<OperationWithExplicitPayloadBlobResponse> responseHandler = new StaxResponseHandler<OperationWithExplicitPayloadBlobResponse>(
                new OperationWithExplicitPayloadBlobResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithExplicitPayloadBlobRequest, OperationWithExplicitPayloadBlobResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithExplicitPayloadBlobRequest)
                        .withMarshaller(new OperationWithExplicitPayloadBlobRequestMarshaller()));
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.
     *
     * @param operationWithGreedyLabelRequest
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithGreedyLabel
     */
    @Override
    public OperationWithGreedyLabelResponse operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) throws SdkServiceException, SdkClientException,
            ProtocolRestXmlException {

        StaxResponseHandler<OperationWithGreedyLabelResponse> responseHandler = new StaxResponseHandler<OperationWithGreedyLabelResponse>(
                new OperationWithGreedyLabelResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithGreedyLabelRequest, OperationWithGreedyLabelResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithGreedyLabelRequest)
                        .withMarshaller(new OperationWithGreedyLabelRequestMarshaller()));
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.OperationWithModeledContentType
     */
    @Override
    public OperationWithModeledContentTypeResponse operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<OperationWithModeledContentTypeResponse> responseHandler = new StaxResponseHandler<OperationWithModeledContentTypeResponse>(
                new OperationWithModeledContentTypeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<OperationWithModeledContentTypeRequest, OperationWithModeledContentTypeResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(operationWithModeledContentTypeRequest)
                        .withMarshaller(new OperationWithModeledContentTypeRequestMarshaller()));
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.QueryParamWithoutValue
     */
    @Override
    public QueryParamWithoutValueResponse queryParamWithoutValue(QueryParamWithoutValueRequest queryParamWithoutValueRequest)
            throws SdkServiceException, SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<QueryParamWithoutValueResponse> responseHandler = new StaxResponseHandler<QueryParamWithoutValueResponse>(
                new QueryParamWithoutValueResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<QueryParamWithoutValueRequest, QueryParamWithoutValueResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(queryParamWithoutValueRequest).withMarshaller(new QueryParamWithoutValueRequestMarshaller()));
    }

    /**
     * Invokes the RestXmlTypes operation.
     *
     * @param restXmlTypesRequest
     * @return Result of the RestXmlTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestXmlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestXmlClient.RestXmlTypes
     */
    @Override
    public RestXmlTypesResponse restXmlTypes(RestXmlTypesRequest restXmlTypesRequest) throws SdkServiceException,
            SdkClientException, ProtocolRestXmlException {

        StaxResponseHandler<RestXmlTypesResponse> responseHandler = new StaxResponseHandler<RestXmlTypesResponse>(
                new RestXmlTypesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RestXmlTypesRequest, RestXmlTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(restXmlTypesRequest).withMarshaller(new RestXmlTypesRequestMarshaller()));
    }

    private List<Unmarshaller<SdkServiceException, Node>> init() {
        List<Unmarshaller<SdkServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new EmptyModeledExceptionUnmarshaller());
        unmarshallers.add(new StandardErrorUnmarshaller(ProtocolRestXmlException.class));
        return unmarshallers;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
