/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolquery.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AllTypesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AllTypesRequestMarshaller implements Marshaller<Request<AllTypesRequest>, AllTypesRequest> {

    public Request<AllTypesRequest> marshall(AllTypesRequest allTypesRequest) {

        if (allTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AllTypesRequest> request = new DefaultRequest<AllTypesRequest>(allTypesRequest, "ProtocolQueryClient");
        request.addParameter("Action", "AllTypes");
        request.addParameter("Version", "2016-03-11");
        request.setHttpMethod(HttpMethodName.POST);

        if (allTypesRequest.stringMember() != null) {
            request.addParameter("stringMember", StringUtils.fromString(allTypesRequest.stringMember()));
        }

        if (allTypesRequest.integerMember() != null) {
            request.addParameter("integerMember", StringUtils.fromInteger(allTypesRequest.integerMember()));
        }

        if (allTypesRequest.booleanMember() != null) {
            request.addParameter("booleanMember", StringUtils.fromBoolean(allTypesRequest.booleanMember()));
        }

        if (allTypesRequest.floatMember() != null) {
            request.addParameter("floatMember", StringUtils.fromFloat(allTypesRequest.floatMember()));
        }

        if (allTypesRequest.doubleMember() != null) {
            request.addParameter("doubleMember", StringUtils.fromDouble(allTypesRequest.doubleMember()));
        }

        if (allTypesRequest.longMember() != null) {
            request.addParameter("longMember", StringUtils.fromLong(allTypesRequest.longMember()));
        }

        SimpleStruct simpleStructMember = allTypesRequest.simpleStructMember();
        if (simpleStructMember != null) {

            if (simpleStructMember.stringMember() != null) {
                request.addParameter("simpleStructMember.StringMember", StringUtils.fromString(simpleStructMember.stringMember()));
            }
        }

        java.util.List<String> simpleListList = allTypesRequest.simpleList();

        if (simpleListList != null) {
            if (!simpleListList.isEmpty()) {
                int simpleListListIndex = 1;

                for (String simpleListListValue : simpleListList) {
                    if (simpleListListValue != null) {
                        request.addParameter("simpleList.member." + simpleListListIndex,
                                StringUtils.fromString(simpleListListValue));
                    }
                    simpleListListIndex++;
                }
            } else {
                request.addParameter("simpleList", "");
            }
        }

        java.util.List<SimpleStruct> listOfStructsList = allTypesRequest.listOfStructs();

        if (listOfStructsList != null) {
            if (!listOfStructsList.isEmpty()) {
                int listOfStructsListIndex = 1;

                for (SimpleStruct listOfStructsListValue : listOfStructsList) {

                    if (listOfStructsListValue.stringMember() != null) {
                        request.addParameter("listOfStructs.member." + listOfStructsListIndex + ".StringMember",
                                StringUtils.fromString(listOfStructsListValue.stringMember()));
                    }
                    listOfStructsListIndex++;
                }
            } else {
                request.addParameter("listOfStructs", "");
            }
        }

        java.util.Map<String, String> mapOfStringToString = allTypesRequest.mapOfStringToString();

        if (mapOfStringToString != null) {
            int mapOfStringToStringListIndex = 1;
            for (Map.Entry<String, String> entry : mapOfStringToString.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("mapOfStringToString.entry." + mapOfStringToStringListIndex + ".key",
                            StringUtils.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("mapOfStringToString.entry." + mapOfStringToStringListIndex + ".value",
                            StringUtils.fromString(entry.getValue()));
                }
                mapOfStringToStringListIndex++;
            }
        }

        if (allTypesRequest.timestampMember() != null) {
            request.addParameter("timestampMember", StringUtils.fromInstant(allTypesRequest.timestampMember()));
        }

        StructWithTimestamp structWithNestedTimestampMember = allTypesRequest.structWithNestedTimestampMember();
        if (structWithNestedTimestampMember != null) {

            if (structWithNestedTimestampMember.nestedTimestamp() != null) {
                request.addParameter("structWithNestedTimestampMember.NestedTimestamp",
                        StringUtils.fromInstant(structWithNestedTimestampMember.nestedTimestamp()));
            }
        }

        if (allTypesRequest.blobArg() != null) {
            request.addParameter("blobArg", StringUtils.fromByteBuffer(allTypesRequest.blobArg()));
        }

        java.util.Map<String, java.nio.ByteBuffer> blobMap = allTypesRequest.blobMap();

        if (blobMap != null) {
            int blobMapListIndex = 1;
            for (Map.Entry<String, java.nio.ByteBuffer> entry : blobMap.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("blobMap.entry." + blobMapListIndex + ".key", StringUtils.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("blobMap.entry." + blobMapListIndex + ".value",
                            StringUtils.fromByteBuffer(entry.getValue()));
                }
                blobMapListIndex++;
            }
        }

        java.util.List<java.nio.ByteBuffer> listOfBlobsList = allTypesRequest.listOfBlobs();

        if (listOfBlobsList != null) {
            if (!listOfBlobsList.isEmpty()) {
                int listOfBlobsListIndex = 1;

                for (java.nio.ByteBuffer listOfBlobsListValue : listOfBlobsList) {
                    if (listOfBlobsListValue != null) {
                        request.addParameter("listOfBlobs.member." + listOfBlobsListIndex,
                                StringUtils.fromByteBuffer(listOfBlobsListValue));
                    }
                    listOfBlobsListIndex++;
                }
            } else {
                request.addParameter("listOfBlobs", "");
            }
        }

        return request;
    }

}
