/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * Ec2TypesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class Ec2TypesRequestMarshaller implements Marshaller<Request<Ec2TypesRequest>, Ec2TypesRequest> {

    public Request<Ec2TypesRequest> marshall(Ec2TypesRequest ec2TypesRequest) {

        if (ec2TypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<Ec2TypesRequest> request = new DefaultRequest<Ec2TypesRequest>(ec2TypesRequest, "ProtocolEc2Client");
        request.addParameter("Action", "Ec2Types");
        request.addParameter("Version", "2016-03-11");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> ec2TypesRequestFlattenedListOfStringsList = ec2TypesRequest.flattenedListOfStrings();
        if (ec2TypesRequestFlattenedListOfStringsList != null) {
            int flattenedListOfStringsListIndex = 1;

            for (String ec2TypesRequestFlattenedListOfStringsListValue : ec2TypesRequestFlattenedListOfStringsList) {
                if (ec2TypesRequestFlattenedListOfStringsListValue != null) {
                    request.addParameter("FlattenedListOfStrings." + flattenedListOfStringsListIndex,
                            StringUtils.fromString(ec2TypesRequestFlattenedListOfStringsListValue));
                }
                flattenedListOfStringsListIndex++;
            }
        }

        java.util.List<SimpleStruct> ec2TypesRequestFlattenedListOfStructsList = ec2TypesRequest.flattenedListOfStructs();
        if (ec2TypesRequestFlattenedListOfStructsList != null) {
            int flattenedListOfStructsListIndex = 1;

            for (SimpleStruct ec2TypesRequestFlattenedListOfStructsListValue : ec2TypesRequestFlattenedListOfStructsList) {

                if (ec2TypesRequestFlattenedListOfStructsListValue.stringMember() != null) {
                    request.addParameter("FlattenedListOfStructs." + flattenedListOfStructsListIndex + ".StringMember",
                            StringUtils.fromString(ec2TypesRequestFlattenedListOfStructsListValue.stringMember()));
                }
                flattenedListOfStructsListIndex++;
            }
        }

        java.util.List<String> ec2TypesRequestFlattenedListWithLocationList = ec2TypesRequest.flattenedListWithLocation();
        if (ec2TypesRequestFlattenedListWithLocationList != null) {
            int flattenedListWithLocationListIndex = 1;

            for (String ec2TypesRequestFlattenedListWithLocationListValue : ec2TypesRequestFlattenedListWithLocationList) {
                if (ec2TypesRequestFlattenedListWithLocationListValue != null) {
                    request.addParameter("ListMemberName." + flattenedListWithLocationListIndex,
                            StringUtils.fromString(ec2TypesRequestFlattenedListWithLocationListValue));
                }
                flattenedListWithLocationListIndex++;
            }
        }

        if (ec2TypesRequest.stringMemberWithLocation() != null) {
            request.addParameter("SomeLocation", StringUtils.fromString(ec2TypesRequest.stringMemberWithLocation()));
        }

        if (ec2TypesRequest.stringMemberWithQueryName() != null) {
            request.addParameter("someQueryName", StringUtils.fromString(ec2TypesRequest.stringMemberWithQueryName()));
        }

        if (ec2TypesRequest.stringMemberWithLocationAndQueryName() != null) {
            request.addParameter("someQueryName", StringUtils.fromString(ec2TypesRequest.stringMemberWithLocationAndQueryName()));
        }

        java.util.List<String> ec2TypesRequestListMemberWithLocationAndQueryNameList = ec2TypesRequest
                .listMemberWithLocationAndQueryName();
        if (ec2TypesRequestListMemberWithLocationAndQueryNameList != null) {
            int listMemberWithLocationAndQueryNameListIndex = 1;

            for (String ec2TypesRequestListMemberWithLocationAndQueryNameListValue : ec2TypesRequestListMemberWithLocationAndQueryNameList) {
                if (ec2TypesRequestListMemberWithLocationAndQueryNameListValue != null) {
                    request.addParameter("listQueryName." + listMemberWithLocationAndQueryNameListIndex,
                            StringUtils.fromString(ec2TypesRequestListMemberWithLocationAndQueryNameListValue));
                }
                listMemberWithLocationAndQueryNameListIndex++;
            }
        }

        java.util.List<String> ec2TypesRequestListMemberWithOnlyMemberLocationList = ec2TypesRequest
                .listMemberWithOnlyMemberLocation();
        if (ec2TypesRequestListMemberWithOnlyMemberLocationList != null) {
            int listMemberWithOnlyMemberLocationListIndex = 1;

            for (String ec2TypesRequestListMemberWithOnlyMemberLocationListValue : ec2TypesRequestListMemberWithOnlyMemberLocationList) {
                if (ec2TypesRequestListMemberWithOnlyMemberLocationListValue != null) {
                    request.addParameter("Item." + listMemberWithOnlyMemberLocationListIndex,
                            StringUtils.fromString(ec2TypesRequestListMemberWithOnlyMemberLocationListValue));
                }
                listMemberWithOnlyMemberLocationListIndex++;
            }
        }

        return request;
    }

}
