/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolquery.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * QueryTypesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class QueryTypesRequestMarshaller implements Marshaller<Request<QueryTypesRequest>, QueryTypesRequest> {

    public Request<QueryTypesRequest> marshall(QueryTypesRequest queryTypesRequest) {

        if (queryTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<QueryTypesRequest> request = new DefaultRequest<QueryTypesRequest>(queryTypesRequest, "ProtocolQueryClient");
        request.addParameter("Action", "QueryTypes");
        request.addParameter("Version", "2016-03-11");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> flattenedListOfStringsList = queryTypesRequest.flattenedListOfStrings();

        if (flattenedListOfStringsList != null) {
            if (!flattenedListOfStringsList.isEmpty()) {
                int flattenedListOfStringsListIndex = 1;

                for (String flattenedListOfStringsListValue : flattenedListOfStringsList) {
                    if (flattenedListOfStringsListValue != null) {
                        request.addParameter("FlattenedListOfStrings." + flattenedListOfStringsListIndex,
                                StringUtils.fromString(flattenedListOfStringsListValue));
                    }
                    flattenedListOfStringsListIndex++;
                }
            } else {
                request.addParameter("FlattenedListOfStrings", "");
            }
        }

        java.util.List<String> nonFlattenedListWithLocationList = queryTypesRequest.nonFlattenedListWithLocation();

        if (nonFlattenedListWithLocationList != null) {
            if (!nonFlattenedListWithLocationList.isEmpty()) {
                int nonFlattenedListWithLocationListIndex = 1;

                for (String nonFlattenedListWithLocationListValue : nonFlattenedListWithLocationList) {
                    if (nonFlattenedListWithLocationListValue != null) {
                        request.addParameter("NonFlattenedListWithLocation.item." + nonFlattenedListWithLocationListIndex,
                                StringUtils.fromString(nonFlattenedListWithLocationListValue));
                    }
                    nonFlattenedListWithLocationListIndex++;
                }
            } else {
                request.addParameter("NonFlattenedListWithLocation", "");
            }
        }

        java.util.List<SimpleStruct> flattenedListOfStructsList = queryTypesRequest.flattenedListOfStructs();

        if (flattenedListOfStructsList != null) {
            if (!flattenedListOfStructsList.isEmpty()) {
                int flattenedListOfStructsListIndex = 1;

                for (SimpleStruct flattenedListOfStructsListValue : flattenedListOfStructsList) {

                    if (flattenedListOfStructsListValue.stringMember() != null) {
                        request.addParameter("FlattenedListOfStructs." + flattenedListOfStructsListIndex + ".StringMember",
                                StringUtils.fromString(flattenedListOfStructsListValue.stringMember()));
                    }
                    flattenedListOfStructsListIndex++;
                }
            } else {
                request.addParameter("FlattenedListOfStructs", "");
            }
        }

        java.util.List<String> flattenedListWithLocationList = queryTypesRequest.flattenedListWithLocation();

        if (flattenedListWithLocationList != null) {
            if (!flattenedListWithLocationList.isEmpty()) {
                int flattenedListWithLocationListIndex = 1;

                for (String flattenedListWithLocationListValue : flattenedListWithLocationList) {
                    if (flattenedListWithLocationListValue != null) {
                        request.addParameter("item." + flattenedListWithLocationListIndex,
                                StringUtils.fromString(flattenedListWithLocationListValue));
                    }
                    flattenedListWithLocationListIndex++;
                }
            } else {
                request.addParameter("item", "");
            }
        }

        java.util.Map<String, String> flattenedMap = queryTypesRequest.flattenedMap();

        if (flattenedMap != null) {
            int flattenedMapListIndex = 1;
            for (Map.Entry<String, String> entry : flattenedMap.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("FlattenedMap." + flattenedMapListIndex + ".key", StringUtils.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("FlattenedMap." + flattenedMapListIndex + ".value",
                            StringUtils.fromString(entry.getValue()));
                }
                flattenedMapListIndex++;
            }
        }

        java.util.Map<String, String> flattenedMapWithLocation = queryTypesRequest.flattenedMapWithLocation();

        if (flattenedMapWithLocation != null) {
            int flattenedMapWithLocationListIndex = 1;
            for (Map.Entry<String, String> entry : flattenedMapWithLocation.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("flatmap." + flattenedMapWithLocationListIndex + ".thekey",
                            StringUtils.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("flatmap." + flattenedMapWithLocationListIndex + ".thevalue",
                            StringUtils.fromString(entry.getValue()));
                }
                flattenedMapWithLocationListIndex++;
            }
        }

        java.util.Map<String, String> nonFlattenedMapWithLocation = queryTypesRequest.nonFlattenedMapWithLocation();

        if (nonFlattenedMapWithLocation != null) {
            int nonFlattenedMapWithLocationListIndex = 1;
            for (Map.Entry<String, String> entry : nonFlattenedMapWithLocation.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("themap.entry." + nonFlattenedMapWithLocationListIndex + ".thekey",
                            StringUtils.fromString(entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("themap.entry." + nonFlattenedMapWithLocationListIndex + ".thevalue",
                            StringUtils.fromString(entry.getValue()));
                }
                nonFlattenedMapWithLocationListIndex++;
            }
        }

        return request;
    }

}
