/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PutScalarsResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutScalarsResponseUnmarshaller implements Unmarshaller<PutScalarsResponse, JsonUnmarshallerContext> {

    public PutScalarsResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        PutScalarsResponse.Builder putScalarsResponseBuilder = PutScalarsResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return putScalarsResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            putScalarsResponseBuilder.scalarsModel(ScalarsModelUnmarshaller.getInstance().unmarshall(context));
            token = context.nextToken();
        }

        return putScalarsResponseBuilder.build();
    }

    private static PutScalarsResponseUnmarshaller INSTANCE;

    public static PutScalarsResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new PutScalarsResponseUnmarshaller();
        return INSTANCE;
    }
}
