/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationWithGreedyLabelRequest extends ProtocolRestXmlRequest implements
        ToCopyableBuilder<OperationWithGreedyLabelRequest.Builder, OperationWithGreedyLabelRequest> {
    private static final SdkField<String> NON_GREEDY_PATH_PARAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OperationWithGreedyLabelRequest::nonGreedyPathParam))
            .setter(setter(Builder::nonGreedyPathParam))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("NonGreedyPathParam")
                    .unmarshallLocationName("NonGreedyPathParam").build()).build();

    private static final SdkField<String> GREEDY_PATH_PARAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OperationWithGreedyLabelRequest::greedyPathParam))
            .setter(setter(Builder::greedyPathParam))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("GreedyPathParam")
                    .unmarshallLocationName("GreedyPathParam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_GREEDY_PATH_PARAM_FIELD,
            GREEDY_PATH_PARAM_FIELD));

    private final String nonGreedyPathParam;

    private final String greedyPathParam;

    private OperationWithGreedyLabelRequest(BuilderImpl builder) {
        super(builder);
        this.nonGreedyPathParam = builder.nonGreedyPathParam;
        this.greedyPathParam = builder.greedyPathParam;
    }

    /**
     * Returns the value of the NonGreedyPathParam property for this object.
     * 
     * @return The value of the NonGreedyPathParam property for this object.
     */
    public String nonGreedyPathParam() {
        return nonGreedyPathParam;
    }

    /**
     * Returns the value of the GreedyPathParam property for this object.
     * 
     * @return The value of the GreedyPathParam property for this object.
     */
    public String greedyPathParam() {
        return greedyPathParam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nonGreedyPathParam());
        hashCode = 31 * hashCode + Objects.hashCode(greedyPathParam());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithGreedyLabelRequest)) {
            return false;
        }
        OperationWithGreedyLabelRequest other = (OperationWithGreedyLabelRequest) obj;
        return Objects.equals(nonGreedyPathParam(), other.nonGreedyPathParam())
                && Objects.equals(greedyPathParam(), other.greedyPathParam());
    }

    @Override
    public String toString() {
        return ToString.builder("OperationWithGreedyLabelRequest").add("NonGreedyPathParam", nonGreedyPathParam())
                .add("GreedyPathParam", greedyPathParam()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonGreedyPathParam":
            return Optional.ofNullable(clazz.cast(nonGreedyPathParam()));
        case "GreedyPathParam":
            return Optional.ofNullable(clazz.cast(greedyPathParam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationWithGreedyLabelRequest, T> g) {
        return obj -> g.apply((OperationWithGreedyLabelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolRestXmlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, OperationWithGreedyLabelRequest> {
        /**
         * Sets the value of the NonGreedyPathParam property for this object.
         *
         * @param nonGreedyPathParam
         *        The new value for the NonGreedyPathParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonGreedyPathParam(String nonGreedyPathParam);

        /**
         * Sets the value of the GreedyPathParam property for this object.
         *
         * @param greedyPathParam
         *        The new value for the GreedyPathParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greedyPathParam(String greedyPathParam);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolRestXmlRequest.BuilderImpl implements Builder {
        private String nonGreedyPathParam;

        private String greedyPathParam;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithGreedyLabelRequest model) {
            super(model);
            nonGreedyPathParam(model.nonGreedyPathParam);
            greedyPathParam(model.greedyPathParam);
        }

        public final String getNonGreedyPathParam() {
            return nonGreedyPathParam;
        }

        @Override
        public final Builder nonGreedyPathParam(String nonGreedyPathParam) {
            this.nonGreedyPathParam = nonGreedyPathParam;
            return this;
        }

        public final void setNonGreedyPathParam(String nonGreedyPathParam) {
            this.nonGreedyPathParam = nonGreedyPathParam;
        }

        public final String getGreedyPathParam() {
            return greedyPathParam;
        }

        @Override
        public final Builder greedyPathParam(String greedyPathParam) {
            this.greedyPathParam = greedyPathParam;
            return this;
        }

        public final void setGreedyPathParam(String greedyPathParam) {
            this.greedyPathParam = greedyPathParam;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OperationWithGreedyLabelRequest build() {
            return new OperationWithGreedyLabelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
