/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdempotentOperationRequest extends ProtocolRestXmlRequest implements
        ToCopyableBuilder<IdempotentOperationRequest.Builder, IdempotentOperationRequest> {
    private static final SdkField<String> PATH_IDEMPOTENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(IdempotentOperationRequest::pathIdempotentToken))
            .setter(setter(Builder::pathIdempotentToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PathParam")
                    .unmarshallLocationName("PathParam").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> QUERY_IDEMPOTENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(IdempotentOperationRequest::queryIdempotentToken))
            .setter(setter(Builder::queryIdempotentToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("QueryParam")
                    .unmarshallLocationName("QueryParam").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> HEADER_IDEMPOTENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(IdempotentOperationRequest::headerIdempotentToken))
            .setter(setter(Builder::headerIdempotentToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-idempotent-header")
                    .unmarshallLocationName("x-amz-idempotent-header").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_IDEMPOTENT_TOKEN_FIELD,
            QUERY_IDEMPOTENT_TOKEN_FIELD, HEADER_IDEMPOTENT_TOKEN_FIELD));

    private final String pathIdempotentToken;

    private final String queryIdempotentToken;

    private final String headerIdempotentToken;

    private IdempotentOperationRequest(BuilderImpl builder) {
        super(builder);
        this.pathIdempotentToken = builder.pathIdempotentToken;
        this.queryIdempotentToken = builder.queryIdempotentToken;
        this.headerIdempotentToken = builder.headerIdempotentToken;
    }

    /**
     * Returns the value of the PathIdempotentToken property for this object.
     * 
     * @return The value of the PathIdempotentToken property for this object.
     */
    public String pathIdempotentToken() {
        return pathIdempotentToken;
    }

    /**
     * Returns the value of the QueryIdempotentToken property for this object.
     * 
     * @return The value of the QueryIdempotentToken property for this object.
     */
    public String queryIdempotentToken() {
        return queryIdempotentToken;
    }

    /**
     * Returns the value of the HeaderIdempotentToken property for this object.
     * 
     * @return The value of the HeaderIdempotentToken property for this object.
     */
    public String headerIdempotentToken() {
        return headerIdempotentToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pathIdempotentToken());
        hashCode = 31 * hashCode + Objects.hashCode(queryIdempotentToken());
        hashCode = 31 * hashCode + Objects.hashCode(headerIdempotentToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdempotentOperationRequest)) {
            return false;
        }
        IdempotentOperationRequest other = (IdempotentOperationRequest) obj;
        return Objects.equals(pathIdempotentToken(), other.pathIdempotentToken())
                && Objects.equals(queryIdempotentToken(), other.queryIdempotentToken())
                && Objects.equals(headerIdempotentToken(), other.headerIdempotentToken());
    }

    @Override
    public String toString() {
        return ToString.builder("IdempotentOperationRequest").add("PathIdempotentToken", pathIdempotentToken())
                .add("QueryIdempotentToken", queryIdempotentToken()).add("HeaderIdempotentToken", headerIdempotentToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PathIdempotentToken":
            return Optional.ofNullable(clazz.cast(pathIdempotentToken()));
        case "QueryIdempotentToken":
            return Optional.ofNullable(clazz.cast(queryIdempotentToken()));
        case "HeaderIdempotentToken":
            return Optional.ofNullable(clazz.cast(headerIdempotentToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdempotentOperationRequest, T> g) {
        return obj -> g.apply((IdempotentOperationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolRestXmlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, IdempotentOperationRequest> {
        /**
         * Sets the value of the PathIdempotentToken property for this object.
         *
         * @param pathIdempotentToken
         *        The new value for the PathIdempotentToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathIdempotentToken(String pathIdempotentToken);

        /**
         * Sets the value of the QueryIdempotentToken property for this object.
         *
         * @param queryIdempotentToken
         *        The new value for the QueryIdempotentToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryIdempotentToken(String queryIdempotentToken);

        /**
         * Sets the value of the HeaderIdempotentToken property for this object.
         *
         * @param headerIdempotentToken
         *        The new value for the HeaderIdempotentToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerIdempotentToken(String headerIdempotentToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolRestXmlRequest.BuilderImpl implements Builder {
        private String pathIdempotentToken;

        private String queryIdempotentToken;

        private String headerIdempotentToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IdempotentOperationRequest model) {
            super(model);
            pathIdempotentToken(model.pathIdempotentToken);
            queryIdempotentToken(model.queryIdempotentToken);
            headerIdempotentToken(model.headerIdempotentToken);
        }

        public final String getPathIdempotentToken() {
            return pathIdempotentToken;
        }

        @Override
        public final Builder pathIdempotentToken(String pathIdempotentToken) {
            this.pathIdempotentToken = pathIdempotentToken;
            return this;
        }

        public final void setPathIdempotentToken(String pathIdempotentToken) {
            this.pathIdempotentToken = pathIdempotentToken;
        }

        public final String getQueryIdempotentToken() {
            return queryIdempotentToken;
        }

        @Override
        public final Builder queryIdempotentToken(String queryIdempotentToken) {
            this.queryIdempotentToken = queryIdempotentToken;
            return this;
        }

        public final void setQueryIdempotentToken(String queryIdempotentToken) {
            this.queryIdempotentToken = queryIdempotentToken;
        }

        public final String getHeaderIdempotentToken() {
            return headerIdempotentToken;
        }

        @Override
        public final Builder headerIdempotentToken(String headerIdempotentToken) {
            this.headerIdempotentToken = headerIdempotentToken;
            return this;
        }

        public final void setHeaderIdempotentToken(String headerIdempotentToken) {
            this.headerIdempotentToken = headerIdempotentToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IdempotentOperationRequest build() {
            return new IdempotentOperationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
