/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class FurtherNestedContainersResponse extends ProtocolRestJsonResponse implements
        ToCopyableBuilder<FurtherNestedContainersResponse.Builder, FurtherNestedContainersResponse> {
    private static final SdkField<List<NestedContainersStructure>> LIST_OF_NESTED_FIELD = SdkField
            .<List<NestedContainersStructure>> builder(MarshallingType.LIST)
            .getter(getter(FurtherNestedContainersResponse::listOfNested))
            .setter(setter(Builder::listOfNested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOfNested").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NestedContainersStructure> builder(MarshallingType.SDK_POJO)
                                            .constructor(NestedContainersStructure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_OF_NESTED_FIELD));

    private final List<NestedContainersStructure> listOfNested;

    private FurtherNestedContainersResponse(BuilderImpl builder) {
        super(builder);
        this.listOfNested = builder.listOfNested;
    }

    /**
     * Returns the value of the ListOfNested property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfNested property for this object.
     */
    public List<NestedContainersStructure> listOfNested() {
        return listOfNested;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listOfNested());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FurtherNestedContainersResponse)) {
            return false;
        }
        FurtherNestedContainersResponse other = (FurtherNestedContainersResponse) obj;
        return Objects.equals(listOfNested(), other.listOfNested());
    }

    @Override
    public String toString() {
        return ToString.builder("FurtherNestedContainersResponse").add("ListOfNested", listOfNested()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListOfNested":
            return Optional.ofNullable(clazz.cast(listOfNested()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FurtherNestedContainersResponse, T> g) {
        return obj -> g.apply((FurtherNestedContainersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolRestJsonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, FurtherNestedContainersResponse> {
        /**
         * Sets the value of the ListOfNested property for this object.
         *
         * @param listOfNested
         *        The new value for the ListOfNested property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfNested(Collection<NestedContainersStructure> listOfNested);

        /**
         * Sets the value of the ListOfNested property for this object.
         *
         * @param listOfNested
         *        The new value for the ListOfNested property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfNested(NestedContainersStructure... listOfNested);

        /**
         * Sets the value of the ListOfNested property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<NestedContainersStructure>.Builder}
         * avoiding the need to create one manually via {@link List<NestedContainersStructure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NestedContainersStructure>.Builder#build()} is called
         * immediately and its result is passed to {@link #listOfNested(List<NestedContainersStructure>)}.
         * 
         * @param listOfNested
         *        a consumer that will call methods on {@link List<NestedContainersStructure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listOfNested(List<NestedContainersStructure>)
         */
        Builder listOfNested(Consumer<NestedContainersStructure.Builder>... listOfNested);
    }

    static final class BuilderImpl extends ProtocolRestJsonResponse.BuilderImpl implements Builder {
        private List<NestedContainersStructure> listOfNested = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FurtherNestedContainersResponse model) {
            super(model);
            listOfNested(model.listOfNested);
        }

        public final Collection<NestedContainersStructure.Builder> getListOfNested() {
            return listOfNested != null ? listOfNested.stream().map(NestedContainersStructure::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listOfNested(Collection<NestedContainersStructure> listOfNested) {
            this.listOfNested = ListOfNestedCopier.copy(listOfNested);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfNested(NestedContainersStructure... listOfNested) {
            listOfNested(Arrays.asList(listOfNested));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfNested(Consumer<NestedContainersStructure.Builder>... listOfNested) {
            listOfNested(Stream.of(listOfNested).map(c -> NestedContainersStructure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setListOfNested(Collection<NestedContainersStructure.BuilderImpl> listOfNested) {
            this.listOfNested = ListOfNestedCopier.copyFromBuilder(listOfNested);
        }

        @Override
        public FurtherNestedContainersResponse build() {
            return new FurtherNestedContainersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
