/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryTypesRequest extends ProtocolQueryRequest implements
        ToCopyableBuilder<QueryTypesRequest.Builder, QueryTypesRequest> {
    private static final SdkField<List<String>> FLATTENED_LIST_OF_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(QueryTypesRequest::flattenedListOfStrings))
            .setter(setter(Builder::flattenedListOfStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlattenedListOfStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final SdkField<List<String>> NON_FLATTENED_LIST_WITH_LOCATION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(QueryTypesRequest::nonFlattenedListWithLocation))
            .setter(setter(Builder::nonFlattenedListWithLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonFlattenedListWithLocation")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("item").build()).build()).build()).build();

    private static final SdkField<List<SimpleStruct>> FLATTENED_LIST_OF_STRUCTS_FIELD = SdkField
            .<List<SimpleStruct>> builder(MarshallingType.LIST)
            .getter(getter(QueryTypesRequest::flattenedListOfStructs))
            .setter(setter(Builder::flattenedListOfStructs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlattenedListOfStructs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimpleStruct> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimpleStruct::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final SdkField<List<String>> FLATTENED_LIST_WITH_LOCATION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(QueryTypesRequest::flattenedListWithLocation))
            .setter(setter(Builder::flattenedListWithLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("item").build()).build()).isFlattened(true).build()).build();

    private static final SdkField<Map<String, String>> FLATTENED_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(QueryTypesRequest::flattenedMap))
            .setter(setter(Builder::flattenedMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlattenedMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).isFlattened(true).build()).build();

    private static final SdkField<Map<String, String>> FLATTENED_MAP_WITH_LOCATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(QueryTypesRequest::flattenedMapWithLocation))
            .setter(setter(Builder::flattenedMapWithLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flatmap").build(),
                    MapTrait.builder()
                            .keyLocationName("thekey")
                            .valueLocationName("thevalue")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("thevalue").build()).build()).isFlattened(true).build())
            .build();

    private static final SdkField<Map<String, String>> NON_FLATTENED_MAP_WITH_LOCATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(QueryTypesRequest::nonFlattenedMapWithLocation))
            .setter(setter(Builder::nonFlattenedMapWithLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("themap").build(),
                    MapTrait.builder()
                            .keyLocationName("thekey")
                            .valueLocationName("thevalue")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("thevalue").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FLATTENED_LIST_OF_STRINGS_FIELD, NON_FLATTENED_LIST_WITH_LOCATION_FIELD, FLATTENED_LIST_OF_STRUCTS_FIELD,
            FLATTENED_LIST_WITH_LOCATION_FIELD, FLATTENED_MAP_FIELD, FLATTENED_MAP_WITH_LOCATION_FIELD,
            NON_FLATTENED_MAP_WITH_LOCATION_FIELD));

    private final List<String> flattenedListOfStrings;

    private final List<String> nonFlattenedListWithLocation;

    private final List<SimpleStruct> flattenedListOfStructs;

    private final List<String> flattenedListWithLocation;

    private final Map<String, String> flattenedMap;

    private final Map<String, String> flattenedMapWithLocation;

    private final Map<String, String> nonFlattenedMapWithLocation;

    private QueryTypesRequest(BuilderImpl builder) {
        super(builder);
        this.flattenedListOfStrings = builder.flattenedListOfStrings;
        this.nonFlattenedListWithLocation = builder.nonFlattenedListWithLocation;
        this.flattenedListOfStructs = builder.flattenedListOfStructs;
        this.flattenedListWithLocation = builder.flattenedListWithLocation;
        this.flattenedMap = builder.flattenedMap;
        this.flattenedMapWithLocation = builder.flattenedMapWithLocation;
        this.nonFlattenedMapWithLocation = builder.nonFlattenedMapWithLocation;
    }

    /**
     * Returns the value of the FlattenedListOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStrings property for this object.
     */
    public List<String> flattenedListOfStrings() {
        return flattenedListOfStrings;
    }

    /**
     * Returns the value of the NonFlattenedListWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the NonFlattenedListWithLocation property for this object.
     */
    public List<String> nonFlattenedListWithLocation() {
        return nonFlattenedListWithLocation;
    }

    /**
     * Returns the value of the FlattenedListOfStructs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStructs property for this object.
     */
    public List<SimpleStruct> flattenedListOfStructs() {
        return flattenedListOfStructs;
    }

    /**
     * Returns the value of the FlattenedListWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListWithLocation property for this object.
     */
    public List<String> flattenedListWithLocation() {
        return flattenedListWithLocation;
    }

    /**
     * Returns the value of the FlattenedMap property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedMap property for this object.
     */
    public Map<String, String> flattenedMap() {
        return flattenedMap;
    }

    /**
     * Returns the value of the FlattenedMapWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedMapWithLocation property for this object.
     */
    public Map<String, String> flattenedMapWithLocation() {
        return flattenedMapWithLocation;
    }

    /**
     * Returns the value of the NonFlattenedMapWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the NonFlattenedMapWithLocation property for this object.
     */
    public Map<String, String> nonFlattenedMapWithLocation() {
        return nonFlattenedMapWithLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flattenedListOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nonFlattenedListWithLocation());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedListOfStructs());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedListWithLocation());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedMap());
        hashCode = 31 * hashCode + Objects.hashCode(flattenedMapWithLocation());
        hashCode = 31 * hashCode + Objects.hashCode(nonFlattenedMapWithLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryTypesRequest)) {
            return false;
        }
        QueryTypesRequest other = (QueryTypesRequest) obj;
        return Objects.equals(flattenedListOfStrings(), other.flattenedListOfStrings())
                && Objects.equals(nonFlattenedListWithLocation(), other.nonFlattenedListWithLocation())
                && Objects.equals(flattenedListOfStructs(), other.flattenedListOfStructs())
                && Objects.equals(flattenedListWithLocation(), other.flattenedListWithLocation())
                && Objects.equals(flattenedMap(), other.flattenedMap())
                && Objects.equals(flattenedMapWithLocation(), other.flattenedMapWithLocation())
                && Objects.equals(nonFlattenedMapWithLocation(), other.nonFlattenedMapWithLocation());
    }

    @Override
    public String toString() {
        return ToString.builder("QueryTypesRequest").add("FlattenedListOfStrings", flattenedListOfStrings())
                .add("NonFlattenedListWithLocation", nonFlattenedListWithLocation())
                .add("FlattenedListOfStructs", flattenedListOfStructs())
                .add("FlattenedListWithLocation", flattenedListWithLocation()).add("FlattenedMap", flattenedMap())
                .add("FlattenedMapWithLocation", flattenedMapWithLocation())
                .add("NonFlattenedMapWithLocation", nonFlattenedMapWithLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlattenedListOfStrings":
            return Optional.ofNullable(clazz.cast(flattenedListOfStrings()));
        case "NonFlattenedListWithLocation":
            return Optional.ofNullable(clazz.cast(nonFlattenedListWithLocation()));
        case "FlattenedListOfStructs":
            return Optional.ofNullable(clazz.cast(flattenedListOfStructs()));
        case "FlattenedListWithLocation":
            return Optional.ofNullable(clazz.cast(flattenedListWithLocation()));
        case "FlattenedMap":
            return Optional.ofNullable(clazz.cast(flattenedMap()));
        case "FlattenedMapWithLocation":
            return Optional.ofNullable(clazz.cast(flattenedMapWithLocation()));
        case "NonFlattenedMapWithLocation":
            return Optional.ofNullable(clazz.cast(nonFlattenedMapWithLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryTypesRequest, T> g) {
        return obj -> g.apply((QueryTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolQueryRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryTypesRequest> {
        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings);

        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(String... flattenedListOfStrings);

        /**
         * Sets the value of the NonFlattenedListWithLocation property for this object.
         *
         * @param nonFlattenedListWithLocation
         *        The new value for the NonFlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation);

        /**
         * Sets the value of the NonFlattenedListWithLocation property for this object.
         *
         * @param nonFlattenedListWithLocation
         *        The new value for the NonFlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedListWithLocation(String... nonFlattenedListWithLocation);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<SimpleStruct>.Builder} avoiding the need to
         * create one manually via {@link List<SimpleStruct>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimpleStruct>.Builder#build()} is called immediately and its
         * result is passed to {@link #flattenedListOfStructs(List<SimpleStruct>)}.
         * 
         * @param flattenedListOfStructs
         *        a consumer that will call methods on {@link List<SimpleStruct>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flattenedListOfStructs(List<SimpleStruct>)
         */
        Builder flattenedListOfStructs(Consumer<SimpleStruct.Builder>... flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(String... flattenedListWithLocation);

        /**
         * Sets the value of the FlattenedMap property for this object.
         *
         * @param flattenedMap
         *        The new value for the FlattenedMap property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedMap(Map<String, String> flattenedMap);

        /**
         * Sets the value of the FlattenedMapWithLocation property for this object.
         *
         * @param flattenedMapWithLocation
         *        The new value for the FlattenedMapWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedMapWithLocation(Map<String, String> flattenedMapWithLocation);

        /**
         * Sets the value of the NonFlattenedMapWithLocation property for this object.
         *
         * @param nonFlattenedMapWithLocation
         *        The new value for the NonFlattenedMapWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolQueryRequest.BuilderImpl implements Builder {
        private List<String> flattenedListOfStrings;

        private List<String> nonFlattenedListWithLocation;

        private List<SimpleStruct> flattenedListOfStructs;

        private List<String> flattenedListWithLocation;

        private Map<String, String> flattenedMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> flattenedMapWithLocation = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> nonFlattenedMapWithLocation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryTypesRequest model) {
            super(model);
            flattenedListOfStrings(model.flattenedListOfStrings);
            nonFlattenedListWithLocation(model.nonFlattenedListWithLocation);
            flattenedListOfStructs(model.flattenedListOfStructs);
            flattenedListWithLocation(model.flattenedListWithLocation);
            flattenedMap(model.flattenedMap);
            flattenedMapWithLocation(model.flattenedMapWithLocation);
            nonFlattenedMapWithLocation(model.nonFlattenedMapWithLocation);
        }

        public final Collection<String> getFlattenedListOfStrings() {
            return flattenedListOfStrings;
        }

        @Override
        public final Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStrings(String... flattenedListOfStrings) {
            flattenedListOfStrings(Arrays.asList(flattenedListOfStrings));
            return this;
        }

        public final void setFlattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
        }

        public final Collection<String> getNonFlattenedListWithLocation() {
            return nonFlattenedListWithLocation;
        }

        @Override
        public final Builder nonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation) {
            this.nonFlattenedListWithLocation = NonFlattenedListWithLocationCopier.copy(nonFlattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonFlattenedListWithLocation(String... nonFlattenedListWithLocation) {
            nonFlattenedListWithLocation(Arrays.asList(nonFlattenedListWithLocation));
            return this;
        }

        public final void setNonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation) {
            this.nonFlattenedListWithLocation = NonFlattenedListWithLocationCopier.copy(nonFlattenedListWithLocation);
        }

        public final Collection<SimpleStruct.Builder> getFlattenedListOfStructs() {
            return flattenedListOfStructs != null ? flattenedListOfStructs.stream().map(SimpleStruct::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            flattenedListOfStructs(Arrays.asList(flattenedListOfStructs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(Consumer<SimpleStruct.Builder>... flattenedListOfStructs) {
            flattenedListOfStructs(Stream.of(flattenedListOfStructs).map(c -> SimpleStruct.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFlattenedListOfStructs(Collection<SimpleStruct.BuilderImpl> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copyFromBuilder(flattenedListOfStructs);
        }

        public final Collection<String> getFlattenedListWithLocation() {
            return flattenedListWithLocation;
        }

        @Override
        public final Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListWithLocation(String... flattenedListWithLocation) {
            flattenedListWithLocation(Arrays.asList(flattenedListWithLocation));
            return this;
        }

        public final void setFlattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
        }

        public final Map<String, String> getFlattenedMap() {
            return flattenedMap;
        }

        @Override
        public final Builder flattenedMap(Map<String, String> flattenedMap) {
            this.flattenedMap = FlattenedMapCopier.copy(flattenedMap);
            return this;
        }

        public final void setFlattenedMap(Map<String, String> flattenedMap) {
            this.flattenedMap = FlattenedMapCopier.copy(flattenedMap);
        }

        public final Map<String, String> getFlattenedMapWithLocation() {
            return flattenedMapWithLocation;
        }

        @Override
        public final Builder flattenedMapWithLocation(Map<String, String> flattenedMapWithLocation) {
            this.flattenedMapWithLocation = FlattenedMapWithLocationCopier.copy(flattenedMapWithLocation);
            return this;
        }

        public final void setFlattenedMapWithLocation(Map<String, String> flattenedMapWithLocation) {
            this.flattenedMapWithLocation = FlattenedMapWithLocationCopier.copy(flattenedMapWithLocation);
        }

        public final Map<String, String> getNonFlattenedMapWithLocation() {
            return nonFlattenedMapWithLocation;
        }

        @Override
        public final Builder nonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation) {
            this.nonFlattenedMapWithLocation = NonFlattenedMapWithLocationCopier.copy(nonFlattenedMapWithLocation);
            return this;
        }

        public final void setNonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation) {
            this.nonFlattenedMapWithLocation = NonFlattenedMapWithLocationCopier.copy(nonFlattenedMapWithLocation);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryTypesRequest build() {
            return new QueryTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
