/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocoljsonrpc.model.AllTypesRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.AllTypesResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.EmptyModeledException;
import software.amazon.awssdk.services.protocoljsonrpc.model.FurtherNestedContainersRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.FurtherNestedContainersResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.ImplicitPayloadException;
import software.amazon.awssdk.services.protocoljsonrpc.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.ProtocolJsonRpcException;

/**
 * Service client for accessing JsonProtocolTests. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolJsonRpcClient extends SdkClient {
    String SERVICE_NAME = "jsonrpc";

    /**
     * Create a {@link ProtocolJsonRpcClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolJsonRpcClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolJsonRpcClient}.
     */
    static ProtocolJsonRpcClientBuilder builder() {
        return new DefaultProtocolJsonRpcClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws ImplicitPayloadException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.AllTypes
     * @see #allTypes(AllTypesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes() throws EmptyModeledException, ImplicitPayloadException, AwsServiceException,
            SdkClientException, ProtocolJsonRpcException {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws ImplicitPayloadException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, ImplicitPayloadException,
            AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllTypesRequest.Builder} avoiding the need to
     * create one manually via {@link AllTypesRequest#builder()}
     * </p>
     *
     * @param allTypesRequest
     *        A {@link Consumer} that will call methods on {@link AllTypesStructure.Builder} to create a request.
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws ImplicitPayloadException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) throws EmptyModeledException,
            ImplicitPayloadException, AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        return allTypes(AllTypesRequest.builder().applyMutation(allTypesRequest).build());
    }

    /**
     * Invokes the FurtherNestedContainers operation.
     *
     * @return Result of the FurtherNestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.FurtherNestedContainers
     * @see #furtherNestedContainers(FurtherNestedContainersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default FurtherNestedContainersResponse furtherNestedContainers() throws AwsServiceException, SdkClientException,
            ProtocolJsonRpcException {
        return furtherNestedContainers(FurtherNestedContainersRequest.builder().build());
    }

    /**
     * Invokes the FurtherNestedContainers operation.
     *
     * @param furtherNestedContainersRequest
     * @return Result of the FurtherNestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default FurtherNestedContainersResponse furtherNestedContainers(FurtherNestedContainersRequest furtherNestedContainersRequest)
            throws AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the FurtherNestedContainers operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FurtherNestedContainersRequest.Builder} avoiding
     * the need to create one manually via {@link FurtherNestedContainersRequest#builder()}
     * </p>
     *
     * @param furtherNestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link FurtherNestedContainersStructure.Builder} to create a
     *        request.
     * @return Result of the FurtherNestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.FurtherNestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/FurtherNestedContainers"
     *      target="_top">AWS API Documentation</a>
     */
    default FurtherNestedContainersResponse furtherNestedContainers(
            Consumer<FurtherNestedContainersRequest.Builder> furtherNestedContainersRequest) throws AwsServiceException,
            SdkClientException, ProtocolJsonRpcException {
        return furtherNestedContainers(FurtherNestedContainersRequest.builder().applyMutation(furtherNestedContainersRequest)
                .build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.IdempotentOperation
     * @see #idempotentOperation(IdempotentOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default IdempotentOperationResponse idempotentOperation() throws AwsServiceException, SdkClientException,
            ProtocolJsonRpcException {
        return idempotentOperation(IdempotentOperationRequest.builder().build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IdempotentOperationRequest.Builder} avoiding the
     * need to create one manually via {@link IdempotentOperationRequest#builder()}
     * </p>
     *
     * @param idempotentOperationRequest
     *        A {@link Consumer} that will call methods on {@link IdempotentOperationStructure.Builder} to create a
     *        request.
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default IdempotentOperationResponse idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolJsonRpcException {
        return idempotentOperation(IdempotentOperationRequest.builder().applyMutation(idempotentOperationRequest).build());
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.NestedContainers
     * @see #nestedContainers(NestedContainersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers() throws AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        return nestedContainers(NestedContainersRequest.builder().build());
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @param nestedContainersRequest
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers(NestedContainersRequest nestedContainersRequest)
            throws AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NestedContainers operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NestedContainersRequest.Builder} avoiding the need
     * to create one manually via {@link NestedContainersRequest#builder()}
     * </p>
     *
     * @param nestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link NestedContainersStructure.Builder} to create a
     *        request.
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers(Consumer<NestedContainersRequest.Builder> nestedContainersRequest)
            throws AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        return nestedContainers(NestedContainersRequest.builder().applyMutation(nestedContainersRequest).build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.OperationWithNoInputOrOutput
     * @see #operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput() throws AwsServiceException, SdkClientException,
            ProtocolJsonRpcException {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws AwsServiceException,
            SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithNoInputOrOutputRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithNoInputOrOutputRequest#builder()}
     * </p>
     *
     * @param operationWithNoInputOrOutputRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithNoInputOrOutputRequest.Builder} to create
     *        a request.
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/jsonrpc-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            Consumer<OperationWithNoInputOrOutputRequest.Builder> operationWithNoInputOrOutputRequest)
            throws AwsServiceException, SdkClientException, ProtocolJsonRpcException {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder()
                .applyMutation(operationWithNoInputOrOutputRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("jsonrpc");
    }
}
