/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.protocolrestjson.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MembersInHeadersResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MembersInHeadersResponseUnmarshaller implements Unmarshaller<MembersInHeadersResponse, JsonUnmarshallerContext> {

    public MembersInHeadersResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        MembersInHeadersResponse.Builder membersInHeadersResponseBuilder = MembersInHeadersResponse.builder();

        if (context.isStartOfDocument()) {
            if (context.getHeader("x-amz-string") != null) {
                context.setCurrentHeader("x-amz-string");
                membersInHeadersResponseBuilder.stringMember(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-boolean") != null) {
                context.setCurrentHeader("x-amz-boolean");
                membersInHeadersResponseBuilder.booleanMember(context.getUnmarshaller(Boolean.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-integer") != null) {
                context.setCurrentHeader("x-amz-integer");
                membersInHeadersResponseBuilder.integerMember(context.getUnmarshaller(Integer.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-long") != null) {
                context.setCurrentHeader("x-amz-long");
                membersInHeadersResponseBuilder.longMember(context.getUnmarshaller(Long.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-float") != null) {
                context.setCurrentHeader("x-amz-float");
                membersInHeadersResponseBuilder.floatMember(context.getUnmarshaller(Float.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-double") != null) {
                context.setCurrentHeader("x-amz-double");
                membersInHeadersResponseBuilder.doubleMember(context.getUnmarshaller(Double.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-timestamp") != null) {
                context.setCurrentHeader("x-amz-timestamp");
                membersInHeadersResponseBuilder.timestampMember(software.amazon.awssdk.core.util.DateUtils
                        .parseRfc1123Date(context.readText()));
            }
        }

        return membersInHeadersResponseBuilder.build();
    }

    private static final MembersInHeadersResponseUnmarshaller INSTANCE = new MembersInHeadersResponseUnmarshaller();

    public static MembersInHeadersResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
