/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2;

import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolec2.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolec2.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolec2.model.Ec2TypesRequest;
import software.amazon.awssdk.services.protocolec2.model.Ec2TypesResponse;
import software.amazon.awssdk.services.protocolec2.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolec2.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolec2.model.ProtocolEc2Exception;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing AmazonProtocolEc2. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolEc2Client extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "ec2";

    /**
     * Create a {@link ProtocolEc2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolEc2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolEc2Client}.
     */
    static ProtocolEc2ClientBuilder builder() {
        return new DefaultProtocolEc2ClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @return Result of the AllTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.AllTypes
     * @see #allTypes(AllTypesRequest)
     */
    default AllTypesResponse allTypes() throws AwsServiceException, SdkClientException, ProtocolEc2Exception {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws AwsServiceException, SdkClientException,
            ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllTypesRequest.Builder} avoiding the need to
     * create one manually via {@link AllTypesRequest#builder()}
     * </p>
     *
     * @param allTypesRequest
     *        A {@link Consumer} that will call methods on {@link AllTypesStructure.Builder} to create a request.
     * @return Result of the AllTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.AllTypes
     */
    default AllTypesResponse allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) throws AwsServiceException,
            SdkClientException, ProtocolEc2Exception {
        return allTypes(AllTypesRequest.builder().apply(allTypesRequest).build());
    }

    /**
     * Invokes the Ec2Types operation.
     *
     * @return Result of the Ec2Types operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.Ec2Types
     * @see #ec2Types(Ec2TypesRequest)
     */
    default Ec2TypesResponse ec2Types() throws AwsServiceException, SdkClientException, ProtocolEc2Exception {
        return ec2Types(Ec2TypesRequest.builder().build());
    }

    /**
     * Invokes the Ec2Types operation.
     *
     * @param ec2TypesRequest
     * @return Result of the Ec2Types operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.Ec2Types
     */
    default Ec2TypesResponse ec2Types(Ec2TypesRequest ec2TypesRequest) throws AwsServiceException, SdkClientException,
            ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the Ec2Types operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link Ec2TypesRequest.Builder} avoiding the need to
     * create one manually via {@link Ec2TypesRequest#builder()}
     * </p>
     *
     * @param ec2TypesRequest
     *        A {@link Consumer} that will call methods on {@link Ec2TypesInput.Builder} to create a request.
     * @return Result of the Ec2Types operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.Ec2Types
     */
    default Ec2TypesResponse ec2Types(Consumer<Ec2TypesRequest.Builder> ec2TypesRequest) throws AwsServiceException,
            SdkClientException, ProtocolEc2Exception {
        return ec2Types(Ec2TypesRequest.builder().apply(ec2TypesRequest).build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.IdempotentOperation
     * @see #idempotentOperation(IdempotentOperationRequest)
     */
    default IdempotentOperationResponse idempotentOperation() throws AwsServiceException, SdkClientException,
            ProtocolEc2Exception {
        return idempotentOperation(IdempotentOperationRequest.builder().build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolEc2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IdempotentOperationRequest.Builder} avoiding the
     * need to create one manually via {@link IdempotentOperationRequest#builder()}
     * </p>
     *
     * @param idempotentOperationRequest
     *        A {@link Consumer} that will call methods on {@link IdempotentOperationStructure.Builder} to create a
     *        request.
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolEc2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolEc2Client.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolEc2Exception {
        return idempotentOperation(IdempotentOperationRequest.builder().apply(idempotentOperationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("ec2");
    }
}
