/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RestXmlTypesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RestXmlTypesRequest.Builder, RestXmlTypesRequest> {
    private final List<String> flattenedListOfStrings;

    private final List<String> nonFlattenedListWithLocation;

    private final List<SimpleStruct> flattenedListOfStructs;

    private final List<String> flattenedListWithLocation;

    private final Map<String, String> flattenedMap;

    private final Map<String, String> flattenedMapWithLocation;

    private final Map<String, String> nonFlattenedMapWithLocation;

    private final String stringMemberInQuery;

    private final Date timestampMemberInHeader;

    private final List<String> listOfStringsInQuery;

    private final Map<String, String> mapOfStringToStringInQuery;

    private RestXmlTypesRequest(BuilderImpl builder) {
        this.flattenedListOfStrings = builder.flattenedListOfStrings;
        this.nonFlattenedListWithLocation = builder.nonFlattenedListWithLocation;
        this.flattenedListOfStructs = builder.flattenedListOfStructs;
        this.flattenedListWithLocation = builder.flattenedListWithLocation;
        this.flattenedMap = builder.flattenedMap;
        this.flattenedMapWithLocation = builder.flattenedMapWithLocation;
        this.nonFlattenedMapWithLocation = builder.nonFlattenedMapWithLocation;
        this.stringMemberInQuery = builder.stringMemberInQuery;
        this.timestampMemberInHeader = builder.timestampMemberInHeader;
        this.listOfStringsInQuery = builder.listOfStringsInQuery;
        this.mapOfStringToStringInQuery = builder.mapOfStringToStringInQuery;
    }

    /**
     *
     * @return
     */
    public List<String> flattenedListOfStrings() {
        return flattenedListOfStrings;
    }

    /**
     *
     * @return
     */
    public List<String> nonFlattenedListWithLocation() {
        return nonFlattenedListWithLocation;
    }

    /**
     *
     * @return
     */
    public List<SimpleStruct> flattenedListOfStructs() {
        return flattenedListOfStructs;
    }

    /**
     *
     * @return
     */
    public List<String> flattenedListWithLocation() {
        return flattenedListWithLocation;
    }

    /**
     *
     * @return
     */
    public Map<String, String> flattenedMap() {
        return flattenedMap;
    }

    /**
     *
     * @return
     */
    public Map<String, String> flattenedMapWithLocation() {
        return flattenedMapWithLocation;
    }

    /**
     *
     * @return
     */
    public Map<String, String> nonFlattenedMapWithLocation() {
        return nonFlattenedMapWithLocation;
    }

    /**
     *
     * @return
     */
    public String stringMemberInQuery() {
        return stringMemberInQuery;
    }

    /**
     *
     * @return
     */
    public Date timestampMemberInHeader() {
        return timestampMemberInHeader;
    }

    /**
     *
     * @return
     */
    public List<String> listOfStringsInQuery() {
        return listOfStringsInQuery;
    }

    /**
     *
     * @return
     */
    public Map<String, String> mapOfStringToStringInQuery() {
        return mapOfStringToStringInQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((flattenedListOfStrings() == null) ? 0 : flattenedListOfStrings().hashCode());
        hashCode = 31 * hashCode + ((nonFlattenedListWithLocation() == null) ? 0 : nonFlattenedListWithLocation().hashCode());
        hashCode = 31 * hashCode + ((flattenedListOfStructs() == null) ? 0 : flattenedListOfStructs().hashCode());
        hashCode = 31 * hashCode + ((flattenedListWithLocation() == null) ? 0 : flattenedListWithLocation().hashCode());
        hashCode = 31 * hashCode + ((flattenedMap() == null) ? 0 : flattenedMap().hashCode());
        hashCode = 31 * hashCode + ((flattenedMapWithLocation() == null) ? 0 : flattenedMapWithLocation().hashCode());
        hashCode = 31 * hashCode + ((nonFlattenedMapWithLocation() == null) ? 0 : nonFlattenedMapWithLocation().hashCode());
        hashCode = 31 * hashCode + ((stringMemberInQuery() == null) ? 0 : stringMemberInQuery().hashCode());
        hashCode = 31 * hashCode + ((timestampMemberInHeader() == null) ? 0 : timestampMemberInHeader().hashCode());
        hashCode = 31 * hashCode + ((listOfStringsInQuery() == null) ? 0 : listOfStringsInQuery().hashCode());
        hashCode = 31 * hashCode + ((mapOfStringToStringInQuery() == null) ? 0 : mapOfStringToStringInQuery().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestXmlTypesRequest)) {
            return false;
        }
        RestXmlTypesRequest other = (RestXmlTypesRequest) obj;
        if (other.flattenedListOfStrings() == null ^ this.flattenedListOfStrings() == null) {
            return false;
        }
        if (other.flattenedListOfStrings() != null && !other.flattenedListOfStrings().equals(this.flattenedListOfStrings())) {
            return false;
        }
        if (other.nonFlattenedListWithLocation() == null ^ this.nonFlattenedListWithLocation() == null) {
            return false;
        }
        if (other.nonFlattenedListWithLocation() != null
                && !other.nonFlattenedListWithLocation().equals(this.nonFlattenedListWithLocation())) {
            return false;
        }
        if (other.flattenedListOfStructs() == null ^ this.flattenedListOfStructs() == null) {
            return false;
        }
        if (other.flattenedListOfStructs() != null && !other.flattenedListOfStructs().equals(this.flattenedListOfStructs())) {
            return false;
        }
        if (other.flattenedListWithLocation() == null ^ this.flattenedListWithLocation() == null) {
            return false;
        }
        if (other.flattenedListWithLocation() != null
                && !other.flattenedListWithLocation().equals(this.flattenedListWithLocation())) {
            return false;
        }
        if (other.flattenedMap() == null ^ this.flattenedMap() == null) {
            return false;
        }
        if (other.flattenedMap() != null && !other.flattenedMap().equals(this.flattenedMap())) {
            return false;
        }
        if (other.flattenedMapWithLocation() == null ^ this.flattenedMapWithLocation() == null) {
            return false;
        }
        if (other.flattenedMapWithLocation() != null && !other.flattenedMapWithLocation().equals(this.flattenedMapWithLocation())) {
            return false;
        }
        if (other.nonFlattenedMapWithLocation() == null ^ this.nonFlattenedMapWithLocation() == null) {
            return false;
        }
        if (other.nonFlattenedMapWithLocation() != null
                && !other.nonFlattenedMapWithLocation().equals(this.nonFlattenedMapWithLocation())) {
            return false;
        }
        if (other.stringMemberInQuery() == null ^ this.stringMemberInQuery() == null) {
            return false;
        }
        if (other.stringMemberInQuery() != null && !other.stringMemberInQuery().equals(this.stringMemberInQuery())) {
            return false;
        }
        if (other.timestampMemberInHeader() == null ^ this.timestampMemberInHeader() == null) {
            return false;
        }
        if (other.timestampMemberInHeader() != null && !other.timestampMemberInHeader().equals(this.timestampMemberInHeader())) {
            return false;
        }
        if (other.listOfStringsInQuery() == null ^ this.listOfStringsInQuery() == null) {
            return false;
        }
        if (other.listOfStringsInQuery() != null && !other.listOfStringsInQuery().equals(this.listOfStringsInQuery())) {
            return false;
        }
        if (other.mapOfStringToStringInQuery() == null ^ this.mapOfStringToStringInQuery() == null) {
            return false;
        }
        if (other.mapOfStringToStringInQuery() != null
                && !other.mapOfStringToStringInQuery().equals(this.mapOfStringToStringInQuery())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (flattenedListOfStrings() != null) {
            sb.append("FlattenedListOfStrings: ").append(flattenedListOfStrings()).append(",");
        }
        if (nonFlattenedListWithLocation() != null) {
            sb.append("NonFlattenedListWithLocation: ").append(nonFlattenedListWithLocation()).append(",");
        }
        if (flattenedListOfStructs() != null) {
            sb.append("FlattenedListOfStructs: ").append(flattenedListOfStructs()).append(",");
        }
        if (flattenedListWithLocation() != null) {
            sb.append("FlattenedListWithLocation: ").append(flattenedListWithLocation()).append(",");
        }
        if (flattenedMap() != null) {
            sb.append("FlattenedMap: ").append(flattenedMap()).append(",");
        }
        if (flattenedMapWithLocation() != null) {
            sb.append("FlattenedMapWithLocation: ").append(flattenedMapWithLocation()).append(",");
        }
        if (nonFlattenedMapWithLocation() != null) {
            sb.append("NonFlattenedMapWithLocation: ").append(nonFlattenedMapWithLocation()).append(",");
        }
        if (stringMemberInQuery() != null) {
            sb.append("StringMemberInQuery: ").append(stringMemberInQuery()).append(",");
        }
        if (timestampMemberInHeader() != null) {
            sb.append("TimestampMemberInHeader: ").append(timestampMemberInHeader()).append(",");
        }
        if (listOfStringsInQuery() != null) {
            sb.append("ListOfStringsInQuery: ").append(listOfStringsInQuery()).append(",");
        }
        if (mapOfStringToStringInQuery() != null) {
            sb.append("MapOfStringToStringInQuery: ").append(mapOfStringToStringInQuery()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RestXmlTypesRequest> {
        /**
         *
         * @param flattenedListOfStrings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFlattenedListOfStrings(java.util.Collection)} or
         * {@link #withFlattenedListOfStrings(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param flattenedListOfStrings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(String... flattenedListOfStrings);

        /**
         *
         * @param nonFlattenedListWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNonFlattenedListWithLocation(java.util.Collection)} or
         * {@link #withNonFlattenedListWithLocation(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param nonFlattenedListWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedListWithLocation(String... nonFlattenedListWithLocation);

        /**
         *
         * @param flattenedListOfStructs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFlattenedListOfStructs(java.util.Collection)} or
         * {@link #withFlattenedListOfStructs(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param flattenedListOfStructs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs);

        /**
         *
         * @param flattenedListWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFlattenedListWithLocation(java.util.Collection)} or
         * {@link #withFlattenedListWithLocation(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param flattenedListWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(String... flattenedListWithLocation);

        /**
         *
         * @param flattenedMap
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedMap(Map<String, String> flattenedMap);

        /**
         *
         * @param flattenedMapWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedMapWithLocation(Map<String, String> flattenedMapWithLocation);

        /**
         *
         * @param nonFlattenedMapWithLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation);

        /**
         *
         * @param stringMemberInQuery
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberInQuery(String stringMemberInQuery);

        /**
         *
         * @param timestampMemberInHeader
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampMemberInHeader(Date timestampMemberInHeader);

        /**
         *
         * @param listOfStringsInQuery
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStringsInQuery(Collection<String> listOfStringsInQuery);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setListOfStringsInQuery(java.util.Collection)} or
         * {@link #withListOfStringsInQuery(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param listOfStringsInQuery
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfStringsInQuery(String... listOfStringsInQuery);

        /**
         *
         * @param mapOfStringToStringInQuery
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapOfStringToStringInQuery(Map<String, String> mapOfStringToStringInQuery);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> flattenedListOfStrings;

        private List<String> nonFlattenedListWithLocation;

        private List<SimpleStruct> flattenedListOfStructs;

        private List<String> flattenedListWithLocation;

        private Map<String, String> flattenedMap;

        private Map<String, String> flattenedMapWithLocation;

        private Map<String, String> nonFlattenedMapWithLocation;

        private String stringMemberInQuery;

        private Date timestampMemberInHeader;

        private List<String> listOfStringsInQuery;

        private Map<String, String> mapOfStringToStringInQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RestXmlTypesRequest model) {
            setFlattenedListOfStrings(model.flattenedListOfStrings);
            setNonFlattenedListWithLocation(model.nonFlattenedListWithLocation);
            setFlattenedListOfStructs(model.flattenedListOfStructs);
            setFlattenedListWithLocation(model.flattenedListWithLocation);
            setFlattenedMap(model.flattenedMap);
            setFlattenedMapWithLocation(model.flattenedMapWithLocation);
            setNonFlattenedMapWithLocation(model.nonFlattenedMapWithLocation);
            setStringMemberInQuery(model.stringMemberInQuery);
            setTimestampMemberInHeader(model.timestampMemberInHeader);
            setListOfStringsInQuery(model.listOfStringsInQuery);
            setMapOfStringToStringInQuery(model.mapOfStringToStringInQuery);
        }

        public final Collection<String> getFlattenedListOfStrings() {
            return flattenedListOfStrings;
        }

        @Override
        public final Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStrings(String... flattenedListOfStrings) {
            if (this.flattenedListOfStrings == null) {
                this.flattenedListOfStrings = new ArrayList<>(flattenedListOfStrings.length);
            }
            for (String e : flattenedListOfStrings) {
                this.flattenedListOfStrings.add(e);
            }
            return this;
        }

        public final void setFlattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
        }

        @SafeVarargs
        public final void setFlattenedListOfStrings(String... flattenedListOfStrings) {
            if (this.flattenedListOfStrings == null) {
                this.flattenedListOfStrings = new ArrayList<>(flattenedListOfStrings.length);
            }
            for (String e : flattenedListOfStrings) {
                this.flattenedListOfStrings.add(e);
            }
        }

        public final Collection<String> getNonFlattenedListWithLocation() {
            return nonFlattenedListWithLocation;
        }

        @Override
        public final Builder nonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation) {
            this.nonFlattenedListWithLocation = NonFlattenedListWithLocationCopier.copy(nonFlattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonFlattenedListWithLocation(String... nonFlattenedListWithLocation) {
            if (this.nonFlattenedListWithLocation == null) {
                this.nonFlattenedListWithLocation = new ArrayList<>(nonFlattenedListWithLocation.length);
            }
            for (String e : nonFlattenedListWithLocation) {
                this.nonFlattenedListWithLocation.add(e);
            }
            return this;
        }

        public final void setNonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation) {
            this.nonFlattenedListWithLocation = NonFlattenedListWithLocationCopier.copy(nonFlattenedListWithLocation);
        }

        @SafeVarargs
        public final void setNonFlattenedListWithLocation(String... nonFlattenedListWithLocation) {
            if (this.nonFlattenedListWithLocation == null) {
                this.nonFlattenedListWithLocation = new ArrayList<>(nonFlattenedListWithLocation.length);
            }
            for (String e : nonFlattenedListWithLocation) {
                this.nonFlattenedListWithLocation.add(e);
            }
        }

        public final Collection<SimpleStruct> getFlattenedListOfStructs() {
            return flattenedListOfStructs;
        }

        @Override
        public final Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            if (this.flattenedListOfStructs == null) {
                this.flattenedListOfStructs = new ArrayList<>(flattenedListOfStructs.length);
            }
            for (SimpleStruct e : flattenedListOfStructs) {
                this.flattenedListOfStructs.add(e);
            }
            return this;
        }

        public final void setFlattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
        }

        @SafeVarargs
        public final void setFlattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            if (this.flattenedListOfStructs == null) {
                this.flattenedListOfStructs = new ArrayList<>(flattenedListOfStructs.length);
            }
            for (SimpleStruct e : flattenedListOfStructs) {
                this.flattenedListOfStructs.add(e);
            }
        }

        public final Collection<String> getFlattenedListWithLocation() {
            return flattenedListWithLocation;
        }

        @Override
        public final Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListWithLocation(String... flattenedListWithLocation) {
            if (this.flattenedListWithLocation == null) {
                this.flattenedListWithLocation = new ArrayList<>(flattenedListWithLocation.length);
            }
            for (String e : flattenedListWithLocation) {
                this.flattenedListWithLocation.add(e);
            }
            return this;
        }

        public final void setFlattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
        }

        @SafeVarargs
        public final void setFlattenedListWithLocation(String... flattenedListWithLocation) {
            if (this.flattenedListWithLocation == null) {
                this.flattenedListWithLocation = new ArrayList<>(flattenedListWithLocation.length);
            }
            for (String e : flattenedListWithLocation) {
                this.flattenedListWithLocation.add(e);
            }
        }

        public final Map<String, String> getFlattenedMap() {
            return flattenedMap;
        }

        @Override
        public final Builder flattenedMap(Map<String, String> flattenedMap) {
            this.flattenedMap = FlattenedMapCopier.copy(flattenedMap);
            return this;
        }

        public final void setFlattenedMap(Map<String, String> flattenedMap) {
            this.flattenedMap = FlattenedMapCopier.copy(flattenedMap);
        }

        public final Map<String, String> getFlattenedMapWithLocation() {
            return flattenedMapWithLocation;
        }

        @Override
        public final Builder flattenedMapWithLocation(Map<String, String> flattenedMapWithLocation) {
            this.flattenedMapWithLocation = FlattenedMapWithLocationCopier.copy(flattenedMapWithLocation);
            return this;
        }

        public final void setFlattenedMapWithLocation(Map<String, String> flattenedMapWithLocation) {
            this.flattenedMapWithLocation = FlattenedMapWithLocationCopier.copy(flattenedMapWithLocation);
        }

        public final Map<String, String> getNonFlattenedMapWithLocation() {
            return nonFlattenedMapWithLocation;
        }

        @Override
        public final Builder nonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation) {
            this.nonFlattenedMapWithLocation = NonFlattenedMapWithLocationCopier.copy(nonFlattenedMapWithLocation);
            return this;
        }

        public final void setNonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation) {
            this.nonFlattenedMapWithLocation = NonFlattenedMapWithLocationCopier.copy(nonFlattenedMapWithLocation);
        }

        public final String getStringMemberInQuery() {
            return stringMemberInQuery;
        }

        @Override
        public final Builder stringMemberInQuery(String stringMemberInQuery) {
            this.stringMemberInQuery = stringMemberInQuery;
            return this;
        }

        public final void setStringMemberInQuery(String stringMemberInQuery) {
            this.stringMemberInQuery = stringMemberInQuery;
        }

        public final Date getTimestampMemberInHeader() {
            return timestampMemberInHeader;
        }

        @Override
        public final Builder timestampMemberInHeader(Date timestampMemberInHeader) {
            this.timestampMemberInHeader = StandardMemberCopier.copy(timestampMemberInHeader);
            return this;
        }

        public final void setTimestampMemberInHeader(Date timestampMemberInHeader) {
            this.timestampMemberInHeader = StandardMemberCopier.copy(timestampMemberInHeader);
        }

        public final Collection<String> getListOfStringsInQuery() {
            return listOfStringsInQuery;
        }

        @Override
        public final Builder listOfStringsInQuery(Collection<String> listOfStringsInQuery) {
            this.listOfStringsInQuery = ListOfStringsCopier.copy(listOfStringsInQuery);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfStringsInQuery(String... listOfStringsInQuery) {
            if (this.listOfStringsInQuery == null) {
                this.listOfStringsInQuery = new ArrayList<>(listOfStringsInQuery.length);
            }
            for (String e : listOfStringsInQuery) {
                this.listOfStringsInQuery.add(e);
            }
            return this;
        }

        public final void setListOfStringsInQuery(Collection<String> listOfStringsInQuery) {
            this.listOfStringsInQuery = ListOfStringsCopier.copy(listOfStringsInQuery);
        }

        @SafeVarargs
        public final void setListOfStringsInQuery(String... listOfStringsInQuery) {
            if (this.listOfStringsInQuery == null) {
                this.listOfStringsInQuery = new ArrayList<>(listOfStringsInQuery.length);
            }
            for (String e : listOfStringsInQuery) {
                this.listOfStringsInQuery.add(e);
            }
        }

        public final Map<String, String> getMapOfStringToStringInQuery() {
            return mapOfStringToStringInQuery;
        }

        @Override
        public final Builder mapOfStringToStringInQuery(Map<String, String> mapOfStringToStringInQuery) {
            this.mapOfStringToStringInQuery = MapOfStringToStringCopier.copy(mapOfStringToStringInQuery);
            return this;
        }

        public final void setMapOfStringToStringInQuery(Map<String, String> mapOfStringToStringInQuery) {
            this.mapOfStringToStringInQuery = MapOfStringToStringCopier.copy(mapOfStringToStringInQuery);
        }

        @Override
        public RestXmlTypesRequest build() {
            return new RestXmlTypesRequest(this);
        }
    }
}
