/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.auth.policy.actions;

import javax.annotation.Generated;

import software.amazon.awssdk.auth.policy.Action;

/**
 * The available AWS access control policy actions for AmazonProtocolRestJsonCustomized.
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public enum RestjsoncustomizedActions implements Action {

    /** Represents any action executed on AmazonProtocolRestJsonCustomized. */
    AllRestjsoncustomizedActions("restjsoncustomized:*"),

    /** Action for the Simple operation. */
    Simple("restjsoncustomized:Simple"),

    ;

    private final String action;

    private RestjsoncustomizedActions(String action) {
        this.action = action;
    }

    public String getActionName() {
        return this.action;
    }
}
