/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pricing.model.PricingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPriceListFileUrlRequest
extends PricingRequest
implements ToCopyableBuilder<Builder, GetPriceListFileUrlRequest> {
    private static final SdkField<String> PRICE_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriceListArn").getter(GetPriceListFileUrlRequest.getter(GetPriceListFileUrlRequest::priceListArn)).setter(GetPriceListFileUrlRequest.setter(Builder::priceListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceListArn").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileFormat").getter(GetPriceListFileUrlRequest.getter(GetPriceListFileUrlRequest::fileFormat)).setter(GetPriceListFileUrlRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_LIST_ARN_FIELD, FILE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPriceListFileUrlRequest.memberNameToFieldInitializer();
    private final String priceListArn;
    private final String fileFormat;

    private GetPriceListFileUrlRequest(BuilderImpl builder) {
        super(builder);
        this.priceListArn = builder.priceListArn;
        this.fileFormat = builder.fileFormat;
    }

    public final String priceListArn() {
        return this.priceListArn;
    }

    public final String fileFormat() {
        return this.fileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.priceListArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPriceListFileUrlRequest)) {
            return false;
        }
        GetPriceListFileUrlRequest other = (GetPriceListFileUrlRequest)((Object)obj);
        return Objects.equals(this.priceListArn(), other.priceListArn()) && Objects.equals(this.fileFormat(), other.fileFormat());
    }

    public final String toString() {
        return ToString.builder((String)"GetPriceListFileUrlRequest").add("PriceListArn", (Object)this.priceListArn()).add("FileFormat", (Object)this.fileFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PriceListArn": {
                return Optional.ofNullable(clazz.cast(this.priceListArn()));
            }
            case "FileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PriceListArn", PRICE_LIST_ARN_FIELD);
        map.put("FileFormat", FILE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPriceListFileUrlRequest, T> g) {
        return obj -> g.apply((GetPriceListFileUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PricingRequest.BuilderImpl
    implements Builder {
        private String priceListArn;
        private String fileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPriceListFileUrlRequest model) {
            super(model);
            this.priceListArn(model.priceListArn);
            this.fileFormat(model.fileFormat);
        }

        public final String getPriceListArn() {
            return this.priceListArn;
        }

        public final void setPriceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
        }

        @Override
        public final Builder priceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPriceListFileUrlRequest build() {
            return new GetPriceListFileUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PricingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPriceListFileUrlRequest> {
        public Builder priceListArn(String var1);

        public Builder fileFormat(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

