/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pricing.model.AttributeNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(Service.getter(Service::serviceCode)).setter(Service.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(Service.getter(Service::attributeNames)).setter(Service.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceCode", SERVICE_CODE_FIELD);
            this.put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final List<String> attributeNames;

    private Service(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.attributeNames = builder.attributeNames;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"Service").add("ServiceCode", (Object)this.serviceCode()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.serviceCode(model.serviceCode);
            this.attributeNames(model.attributeNames);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder serviceCode(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

