/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pricing.DefaultPricingAsyncClient;
import software.amazon.awssdk.services.pricing.DefaultPricingBaseClientBuilder;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.PricingAsyncClientBuilder;
import software.amazon.awssdk.services.pricing.PricingServiceClientConfiguration;
import software.amazon.awssdk.services.pricing.endpoints.PricingEndpointProvider;

@SdkInternalApi
final class DefaultPricingAsyncClientBuilder
extends DefaultPricingBaseClientBuilder<PricingAsyncClientBuilder, PricingAsyncClient>
implements PricingAsyncClientBuilder {
    DefaultPricingAsyncClientBuilder() {
    }

    @Override
    public DefaultPricingAsyncClientBuilder endpointProvider(PricingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PricingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPricingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PricingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPricingAsyncClient client = new DefaultPricingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PricingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PricingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

