/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;

public class GetProductsIterable
implements SdkIterable<GetProductsResponse> {
    private final PricingClient client;
    private final GetProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetProductsIterable(PricingClient client, GetProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetProductsResponseFetcher();
    }

    public Iterator<GetProductsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetProductsResponseFetcher
    implements SyncPageFetcher<GetProductsResponse> {
        private GetProductsResponseFetcher() {
        }

        public boolean hasNextPage(GetProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetProductsResponse nextPage(GetProductsResponse previousPage) {
            if (previousPage == null) {
                return GetProductsIterable.this.client.getProducts(GetProductsIterable.this.firstRequest);
            }
            return GetProductsIterable.this.client.getProducts((GetProductsRequest)((Object)GetProductsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

