/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.services.pricing.model.GetProductsResponse;

public class GetProductsPublisher
implements SdkPublisher<GetProductsResponse> {
    private final PricingAsyncClient client;
    private final GetProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetProductsPublisher(PricingAsyncClient client, GetProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetProductsPublisher(PricingAsyncClient client, GetProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetProductsPublisher resume(GetProductsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetProductsPublisher(this.client, (GetProductsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetProductsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetProductsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetProductsResponseFetcher
    implements AsyncPageFetcher<GetProductsResponse> {
        private GetProductsResponseFetcher() {
        }

        public boolean hasNextPage(GetProductsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetProductsResponse> nextPage(GetProductsResponse previousPage) {
            if (previousPage == null) {
                return GetProductsPublisher.this.client.getProducts(GetProductsPublisher.this.firstRequest);
            }
            return GetProductsPublisher.this.client.getProducts((GetProductsRequest)((Object)GetProductsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

