/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;

public class GetAttributeValuesPublisher
implements SdkPublisher<GetAttributeValuesResponse> {
    private final PricingAsyncClient client;
    private final GetAttributeValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAttributeValuesPublisher(PricingAsyncClient client, GetAttributeValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAttributeValuesPublisher(PricingAsyncClient client, GetAttributeValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAttributeValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAttributeValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetAttributeValuesPublisher resume(GetAttributeValuesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetAttributeValuesPublisher(this.client, (GetAttributeValuesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetAttributeValuesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetAttributeValuesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetAttributeValuesResponseFetcher
    implements AsyncPageFetcher<GetAttributeValuesResponse> {
        private GetAttributeValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetAttributeValuesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetAttributeValuesResponse> nextPage(GetAttributeValuesResponse previousPage) {
            if (previousPage == null) {
                return GetAttributeValuesPublisher.this.client.getAttributeValues(GetAttributeValuesPublisher.this.firstRequest);
            }
            return GetAttributeValuesPublisher.this.client.getAttributeValues((GetAttributeValuesRequest)((Object)GetAttributeValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

