/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadata;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegistrationAssociationsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, ListRegistrationAssociationsResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationArn").getter(ListRegistrationAssociationsResponse.getter(ListRegistrationAssociationsResponse::registrationArn)).setter(ListRegistrationAssociationsResponse.setter(Builder::registrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(ListRegistrationAssociationsResponse.getter(ListRegistrationAssociationsResponse::registrationId)).setter(ListRegistrationAssociationsResponse.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationType").getter(ListRegistrationAssociationsResponse.getter(ListRegistrationAssociationsResponse::registrationType)).setter(ListRegistrationAssociationsResponse.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()}).build();
    private static final SdkField<List<RegistrationAssociationMetadata>> REGISTRATION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationAssociations").getter(ListRegistrationAssociationsResponse.getter(ListRegistrationAssociationsResponse::registrationAssociations)).setter(ListRegistrationAssociationsResponse.setter(Builder::registrationAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationAssociationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegistrationAssociationsResponse.getter(ListRegistrationAssociationsResponse::nextToken)).setter(ListRegistrationAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, REGISTRATION_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRegistrationAssociationsResponse.memberNameToFieldInitializer();
    private final String registrationArn;
    private final String registrationId;
    private final String registrationType;
    private final List<RegistrationAssociationMetadata> registrationAssociations;
    private final String nextToken;

    private ListRegistrationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.registrationAssociations = builder.registrationAssociations;
        this.nextToken = builder.nextToken;
    }

    public final String registrationArn() {
        return this.registrationArn;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final String registrationType() {
        return this.registrationType;
    }

    public final boolean hasRegistrationAssociations() {
        return this.registrationAssociations != null && !(this.registrationAssociations instanceof SdkAutoConstructList);
    }

    public final List<RegistrationAssociationMetadata> registrationAssociations() {
        return this.registrationAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationAssociations() ? this.registrationAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistrationAssociationsResponse)) {
            return false;
        }
        ListRegistrationAssociationsResponse other = (ListRegistrationAssociationsResponse)((Object)obj);
        return Objects.equals(this.registrationArn(), other.registrationArn()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.registrationType(), other.registrationType()) && this.hasRegistrationAssociations() == other.hasRegistrationAssociations() && Objects.equals(this.registrationAssociations(), other.registrationAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegistrationAssociationsResponse").add("RegistrationArn", (Object)this.registrationArn()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationType", (Object)this.registrationType()).add("RegistrationAssociations", this.hasRegistrationAssociations() ? this.registrationAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationArn": {
                return Optional.ofNullable(clazz.cast(this.registrationArn()));
            }
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "RegistrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationType()));
            }
            case "RegistrationAssociations": {
                return Optional.ofNullable(clazz.cast(this.registrationAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("RegistrationAssociations", REGISTRATION_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegistrationAssociationsResponse, T> g) {
        return obj -> g.apply((ListRegistrationAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationArn;
        private String registrationId;
        private String registrationType;
        private List<RegistrationAssociationMetadata> registrationAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistrationAssociationsResponse model) {
            super(model);
            this.registrationArn(model.registrationArn);
            this.registrationId(model.registrationId);
            this.registrationType(model.registrationType);
            this.registrationAssociations(model.registrationAssociations);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationArn() {
            return this.registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<RegistrationAssociationMetadata.Builder> getRegistrationAssociations() {
            List<RegistrationAssociationMetadata.Builder> result = RegistrationAssociationMetadataListCopier.copyToBuilder(this.registrationAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationAssociations(Collection<RegistrationAssociationMetadata.BuilderImpl> registrationAssociations) {
            this.registrationAssociations = RegistrationAssociationMetadataListCopier.copyFromBuilder(registrationAssociations);
        }

        @Override
        public final Builder registrationAssociations(Collection<RegistrationAssociationMetadata> registrationAssociations) {
            this.registrationAssociations = RegistrationAssociationMetadataListCopier.copy(registrationAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAssociations(RegistrationAssociationMetadata ... registrationAssociations) {
            this.registrationAssociations(Arrays.asList(registrationAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAssociations(Consumer<RegistrationAssociationMetadata.Builder> ... registrationAssociations) {
            this.registrationAssociations(Stream.of(registrationAssociations).map(c -> (RegistrationAssociationMetadata)((RegistrationAssociationMetadata.Builder)RegistrationAssociationMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRegistrationAssociationsResponse build() {
            return new ListRegistrationAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegistrationAssociationsResponse> {
        public Builder registrationArn(String var1);

        public Builder registrationId(String var1);

        public Builder registrationType(String var1);

        public Builder registrationAssociations(Collection<RegistrationAssociationMetadata> var1);

        public Builder registrationAssociations(RegistrationAssociationMetadata ... var1);

        public Builder registrationAssociations(Consumer<RegistrationAssociationMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

