/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationVersionsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeRegistrationVersionsResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationArn").getter(DescribeRegistrationVersionsResponse.getter(DescribeRegistrationVersionsResponse::registrationArn)).setter(DescribeRegistrationVersionsResponse.setter(Builder::registrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(DescribeRegistrationVersionsResponse.getter(DescribeRegistrationVersionsResponse::registrationId)).setter(DescribeRegistrationVersionsResponse.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<List<RegistrationVersionInformation>> REGISTRATION_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationVersions").getter(DescribeRegistrationVersionsResponse.getter(DescribeRegistrationVersionsResponse::registrationVersions)).setter(DescribeRegistrationVersionsResponse.setter(Builder::registrationVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationVersionInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationVersionsResponse.getter(DescribeRegistrationVersionsResponse::nextToken)).setter(DescribeRegistrationVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRegistrationVersionsResponse.memberNameToFieldInitializer();
    private final String registrationArn;
    private final String registrationId;
    private final List<RegistrationVersionInformation> registrationVersions;
    private final String nextToken;

    private DescribeRegistrationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.registrationVersions = builder.registrationVersions;
        this.nextToken = builder.nextToken;
    }

    public final String registrationArn() {
        return this.registrationArn;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final boolean hasRegistrationVersions() {
        return this.registrationVersions != null && !(this.registrationVersions instanceof SdkAutoConstructList);
    }

    public final List<RegistrationVersionInformation> registrationVersions() {
        return this.registrationVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationVersions() ? this.registrationVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationVersionsResponse)) {
            return false;
        }
        DescribeRegistrationVersionsResponse other = (DescribeRegistrationVersionsResponse)((Object)obj);
        return Objects.equals(this.registrationArn(), other.registrationArn()) && Objects.equals(this.registrationId(), other.registrationId()) && this.hasRegistrationVersions() == other.hasRegistrationVersions() && Objects.equals(this.registrationVersions(), other.registrationVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationVersionsResponse").add("RegistrationArn", (Object)this.registrationArn()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationVersions", this.hasRegistrationVersions() ? this.registrationVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationArn": {
                return Optional.ofNullable(clazz.cast(this.registrationArn()));
            }
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "RegistrationVersions": {
                return Optional.ofNullable(clazz.cast(this.registrationVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("RegistrationVersions", REGISTRATION_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationVersionsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationArn;
        private String registrationId;
        private List<RegistrationVersionInformation> registrationVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationVersionsResponse model) {
            super(model);
            this.registrationArn(model.registrationArn);
            this.registrationId(model.registrationId);
            this.registrationVersions(model.registrationVersions);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationArn() {
            return this.registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final List<RegistrationVersionInformation.Builder> getRegistrationVersions() {
            List<RegistrationVersionInformation.Builder> result = RegistrationVersionInformationListCopier.copyToBuilder(this.registrationVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationVersions(Collection<RegistrationVersionInformation.BuilderImpl> registrationVersions) {
            this.registrationVersions = RegistrationVersionInformationListCopier.copyFromBuilder(registrationVersions);
        }

        @Override
        public final Builder registrationVersions(Collection<RegistrationVersionInformation> registrationVersions) {
            this.registrationVersions = RegistrationVersionInformationListCopier.copy(registrationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationVersions(RegistrationVersionInformation ... registrationVersions) {
            this.registrationVersions(Arrays.asList(registrationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationVersions(Consumer<RegistrationVersionInformation.Builder> ... registrationVersions) {
            this.registrationVersions(Stream.of(registrationVersions).map(c -> (RegistrationVersionInformation)((RegistrationVersionInformation.Builder)RegistrationVersionInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationVersionsResponse build() {
            return new DescribeRegistrationVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationVersionsResponse> {
        public Builder registrationArn(String var1);

        public Builder registrationId(String var1);

        public Builder registrationVersions(Collection<RegistrationVersionInformation> var1);

        public Builder registrationVersions(RegistrationVersionInformation ... var1);

        public Builder registrationVersions(Consumer<RegistrationVersionInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

