/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation;

public class DescribeRegistrationsIterable
implements SdkIterable<DescribeRegistrationsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationsIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationsResponseFetcher();
    }

    public Iterator<DescribeRegistrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationInformation> registrations() {
        Function<DescribeRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrations() != null) {
                return response.registrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationsResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationsResponse> {
        private DescribeRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationsResponse nextPage(DescribeRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationsIterable.this.client.describeRegistrations(DescribeRegistrationsIterable.this.firstRequest);
            }
            return DescribeRegistrationsIterable.this.client.describeRegistrations((DescribeRegistrationsRequest)((Object)DescribeRegistrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

