/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationVersionsRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeRegistrationVersionsRequest> {
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(DescribeRegistrationVersionsRequest.getter(DescribeRegistrationVersionsRequest::registrationId)).setter(DescribeRegistrationVersionsRequest.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<List<Long>> VERSION_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VersionNumbers").getter(DescribeRegistrationVersionsRequest.getter(DescribeRegistrationVersionsRequest::versionNumbers)).setter(DescribeRegistrationVersionsRequest.setter(Builder::versionNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RegistrationVersionFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeRegistrationVersionsRequest.getter(DescribeRegistrationVersionsRequest::filters)).setter(DescribeRegistrationVersionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationVersionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationVersionsRequest.getter(DescribeRegistrationVersionsRequest::nextToken)).setter(DescribeRegistrationVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeRegistrationVersionsRequest.getter(DescribeRegistrationVersionsRequest::maxResults)).setter(DescribeRegistrationVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ID_FIELD, VERSION_NUMBERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRegistrationVersionsRequest.memberNameToFieldInitializer();
    private final String registrationId;
    private final List<Long> versionNumbers;
    private final List<RegistrationVersionFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeRegistrationVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.registrationId = builder.registrationId;
        this.versionNumbers = builder.versionNumbers;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final boolean hasVersionNumbers() {
        return this.versionNumbers != null && !(this.versionNumbers instanceof SdkAutoConstructList);
    }

    public final List<Long> versionNumbers() {
        return this.versionNumbers;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<RegistrationVersionFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionNumbers() ? this.versionNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationVersionsRequest)) {
            return false;
        }
        DescribeRegistrationVersionsRequest other = (DescribeRegistrationVersionsRequest)((Object)obj);
        return Objects.equals(this.registrationId(), other.registrationId()) && this.hasVersionNumbers() == other.hasVersionNumbers() && Objects.equals(this.versionNumbers(), other.versionNumbers()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationVersionsRequest").add("RegistrationId", (Object)this.registrationId()).add("VersionNumbers", this.hasVersionNumbers() ? this.versionNumbers() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "VersionNumbers": {
                return Optional.ofNullable(clazz.cast(this.versionNumbers()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("VersionNumbers", VERSION_NUMBERS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationVersionsRequest, T> g) {
        return obj -> g.apply((DescribeRegistrationVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String registrationId;
        private List<Long> versionNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<RegistrationVersionFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationVersionsRequest model) {
            super(model);
            this.registrationId(model.registrationId);
            this.versionNumbers(model.versionNumbers);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Collection<Long> getVersionNumbers() {
            if (this.versionNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versionNumbers;
        }

        public final void setVersionNumbers(Collection<Long> versionNumbers) {
            this.versionNumbers = RegistrationVersionNumberListCopier.copy(versionNumbers);
        }

        @Override
        public final Builder versionNumbers(Collection<Long> versionNumbers) {
            this.versionNumbers = RegistrationVersionNumberListCopier.copy(versionNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionNumbers(Long ... versionNumbers) {
            this.versionNumbers(Arrays.asList(versionNumbers));
            return this;
        }

        public final List<RegistrationVersionFilter.Builder> getFilters() {
            List<RegistrationVersionFilter.Builder> result = RegistrationVersionFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<RegistrationVersionFilter.BuilderImpl> filters) {
            this.filters = RegistrationVersionFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<RegistrationVersionFilter> filters) {
            this.filters = RegistrationVersionFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(RegistrationVersionFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<RegistrationVersionFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (RegistrationVersionFilter)((RegistrationVersionFilter.Builder)RegistrationVersionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegistrationVersionsRequest build() {
            return new DescribeRegistrationVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationVersionsRequest> {
        public Builder registrationId(String var1);

        public Builder versionNumbers(Collection<Long> var1);

        public Builder versionNumbers(Long ... var1);

        public Builder filters(Collection<RegistrationVersionFilter> var1);

        public Builder filters(RegistrationVersionFilter ... var1);

        public Builder filters(Consumer<RegistrationVersionFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

