/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation;

public class DescribeRegistrationsPublisher
implements SdkPublisher<DescribeRegistrationsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationInformation> registrations() {
        Function<DescribeRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrations() != null) {
                return response.registrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationsResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationsResponse> {
        private DescribeRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationsResponse> nextPage(DescribeRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationsPublisher.this.client.describeRegistrations(DescribeRegistrationsPublisher.this.firstRequest);
            }
            return DescribeRegistrationsPublisher.this.client.describeRegistrations((DescribeRegistrationsRequest)((Object)DescribeRegistrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

