/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition;

public class DescribeRegistrationSectionDefinitionsIterable
implements SdkIterable<DescribeRegistrationSectionDefinitionsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationSectionDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationSectionDefinitionsIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationSectionDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationSectionDefinitionsResponseFetcher();
    }

    public Iterator<DescribeRegistrationSectionDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationSectionDefinition> registrationSectionDefinitions() {
        Function<DescribeRegistrationSectionDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationSectionDefinitions() != null) {
                return response.registrationSectionDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationSectionDefinitionsResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationSectionDefinitionsResponse> {
        private DescribeRegistrationSectionDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationSectionDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationSectionDefinitionsResponse nextPage(DescribeRegistrationSectionDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationSectionDefinitionsIterable.this.client.describeRegistrationSectionDefinitions(DescribeRegistrationSectionDefinitionsIterable.this.firstRequest);
            }
            return DescribeRegistrationSectionDefinitionsIterable.this.client.describeRegistrationSectionDefinitions((DescribeRegistrationSectionDefinitionsRequest)((Object)DescribeRegistrationSectionDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

