/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata;

public class ListPoolOriginationIdentitiesIterable
implements SdkIterable<ListPoolOriginationIdentitiesResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final ListPoolOriginationIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPoolOriginationIdentitiesIterable(PinpointSmsVoiceV2Client client, ListPoolOriginationIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPoolOriginationIdentitiesResponseFetcher();
    }

    public Iterator<ListPoolOriginationIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OriginationIdentityMetadata> originationIdentities() {
        Function<ListPoolOriginationIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.originationIdentities() != null) {
                return response.originationIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPoolOriginationIdentitiesResponseFetcher
    implements SyncPageFetcher<ListPoolOriginationIdentitiesResponse> {
        private ListPoolOriginationIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoolOriginationIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPoolOriginationIdentitiesResponse nextPage(ListPoolOriginationIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListPoolOriginationIdentitiesIterable.this.client.listPoolOriginationIdentities(ListPoolOriginationIdentitiesIterable.this.firstRequest);
            }
            return ListPoolOriginationIdentitiesIterable.this.client.listPoolOriginationIdentities((ListPoolOriginationIdentitiesRequest)((Object)ListPoolOriginationIdentitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

