/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ContextMapCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VoiceId;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VoiceMessageBodyTextType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendVoiceMessageRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, SendVoiceMessageRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPhoneNumber").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::destinationPhoneNumber)).setter(SendVoiceMessageRequest.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentity").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::originationIdentity)).setter(SendVoiceMessageRequest.setter(Builder::originationIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build()}).build();
    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageBody").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::messageBody)).setter(SendVoiceMessageRequest.setter(Builder::messageBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()}).build();
    private static final SdkField<String> MESSAGE_BODY_TEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageBodyTextType").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::messageBodyTextTypeAsString)).setter(SendVoiceMessageRequest.setter(Builder::messageBodyTextType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBodyTextType").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::voiceIdAsString)).setter(SendVoiceMessageRequest.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::configurationSetName)).setter(SendVoiceMessageRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> MAX_PRICE_PER_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxPricePerMinute").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::maxPricePerMinute)).setter(SendVoiceMessageRequest.setter(Builder::maxPricePerMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPricePerMinute").build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeToLive").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::timeToLive)).setter(SendVoiceMessageRequest.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Context").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::context)).setter(SendVoiceMessageRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::dryRun)).setter(SendVoiceMessageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(SendVoiceMessageRequest.getter(SendVoiceMessageRequest::protectConfigurationId)).setter(SendVoiceMessageRequest.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_IDENTITY_FIELD, MESSAGE_BODY_FIELD, MESSAGE_BODY_TEXT_TYPE_FIELD, VOICE_ID_FIELD, CONFIGURATION_SET_NAME_FIELD, MAX_PRICE_PER_MINUTE_FIELD, TIME_TO_LIVE_FIELD, CONTEXT_FIELD, DRY_RUN_FIELD, PROTECT_CONFIGURATION_ID_FIELD));
    private final String destinationPhoneNumber;
    private final String originationIdentity;
    private final String messageBody;
    private final String messageBodyTextType;
    private final String voiceId;
    private final String configurationSetName;
    private final String maxPricePerMinute;
    private final Integer timeToLive;
    private final Map<String, String> context;
    private final Boolean dryRun;
    private final String protectConfigurationId;

    private SendVoiceMessageRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationIdentity = builder.originationIdentity;
        this.messageBody = builder.messageBody;
        this.messageBodyTextType = builder.messageBodyTextType;
        this.voiceId = builder.voiceId;
        this.configurationSetName = builder.configurationSetName;
        this.maxPricePerMinute = builder.maxPricePerMinute;
        this.timeToLive = builder.timeToLive;
        this.context = builder.context;
        this.dryRun = builder.dryRun;
        this.protectConfigurationId = builder.protectConfigurationId;
    }

    public final String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public final String originationIdentity() {
        return this.originationIdentity;
    }

    public final String messageBody() {
        return this.messageBody;
    }

    public final VoiceMessageBodyTextType messageBodyTextType() {
        return VoiceMessageBodyTextType.fromValue(this.messageBodyTextType);
    }

    public final String messageBodyTextTypeAsString() {
        return this.messageBodyTextType;
    }

    public final VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public final String voiceIdAsString() {
        return this.voiceId;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final String maxPricePerMinute() {
        return this.maxPricePerMinute;
    }

    public final Integer timeToLive() {
        return this.timeToLive;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBodyTextTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPricePerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendVoiceMessageRequest)) {
            return false;
        }
        SendVoiceMessageRequest other = (SendVoiceMessageRequest)((Object)obj);
        return Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.originationIdentity(), other.originationIdentity()) && Objects.equals(this.messageBody(), other.messageBody()) && Objects.equals(this.messageBodyTextTypeAsString(), other.messageBodyTextTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.maxPricePerMinute(), other.maxPricePerMinute()) && Objects.equals(this.timeToLive(), other.timeToLive()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId());
    }

    public final String toString() {
        return ToString.builder((String)"SendVoiceMessageRequest").add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("OriginationIdentity", (Object)this.originationIdentity()).add("MessageBody", (Object)this.messageBody()).add("MessageBodyTextType", (Object)this.messageBodyTextTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("MaxPricePerMinute", (Object)this.maxPricePerMinute()).add("TimeToLive", (Object)this.timeToLive()).add("Context", this.hasContext() ? this.context() : null).add("DryRun", (Object)this.dryRun()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "OriginationIdentity": {
                return Optional.ofNullable(clazz.cast(this.originationIdentity()));
            }
            case "MessageBody": {
                return Optional.ofNullable(clazz.cast(this.messageBody()));
            }
            case "MessageBodyTextType": {
                return Optional.ofNullable(clazz.cast(this.messageBodyTextTypeAsString()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceIdAsString()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "MaxPricePerMinute": {
                return Optional.ofNullable(clazz.cast(this.maxPricePerMinute()));
            }
            case "TimeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendVoiceMessageRequest, T> g) {
        return obj -> g.apply((SendVoiceMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String destinationPhoneNumber;
        private String originationIdentity;
        private String messageBody;
        private String messageBodyTextType;
        private String voiceId;
        private String configurationSetName;
        private String maxPricePerMinute;
        private Integer timeToLive;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private Boolean dryRun;
        private String protectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendVoiceMessageRequest model) {
            super(model);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.originationIdentity(model.originationIdentity);
            this.messageBody(model.messageBody);
            this.messageBodyTextType(model.messageBodyTextType);
            this.voiceId(model.voiceId);
            this.configurationSetName(model.configurationSetName);
            this.maxPricePerMinute(model.maxPricePerMinute);
            this.timeToLive(model.timeToLive);
            this.context(model.context);
            this.dryRun(model.dryRun);
            this.protectConfigurationId(model.protectConfigurationId);
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationIdentity() {
            return this.originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final String getMessageBodyTextType() {
            return this.messageBodyTextType;
        }

        public final void setMessageBodyTextType(String messageBodyTextType) {
            this.messageBodyTextType = messageBodyTextType;
        }

        @Override
        public final Builder messageBodyTextType(String messageBodyTextType) {
            this.messageBodyTextType = messageBodyTextType;
            return this;
        }

        @Override
        public final Builder messageBodyTextType(VoiceMessageBodyTextType messageBodyTextType) {
            this.messageBodyTextType(messageBodyTextType == null ? null : messageBodyTextType.toString());
            return this;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId == null ? null : voiceId.toString());
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMaxPricePerMinute() {
            return this.maxPricePerMinute;
        }

        public final void setMaxPricePerMinute(String maxPricePerMinute) {
            this.maxPricePerMinute = maxPricePerMinute;
        }

        @Override
        public final Builder maxPricePerMinute(String maxPricePerMinute) {
            this.maxPricePerMinute = maxPricePerMinute;
            return this;
        }

        public final Integer getTimeToLive() {
            return this.timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendVoiceMessageRequest build() {
            return new SendVoiceMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendVoiceMessageRequest> {
        public Builder destinationPhoneNumber(String var1);

        public Builder originationIdentity(String var1);

        public Builder messageBody(String var1);

        public Builder messageBodyTextType(String var1);

        public Builder messageBodyTextType(VoiceMessageBodyTextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder configurationSetName(String var1);

        public Builder maxPricePerMinute(String var1);

        public Builder timeToLive(Integer var1);

        public Builder context(Map<String, String> var1);

        public Builder dryRun(Boolean var1);

        public Builder protectConfigurationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

