/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldDefinition;

public class DescribeRegistrationFieldDefinitionsPublisher
implements SdkPublisher<DescribeRegistrationFieldDefinitionsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationFieldDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationFieldDefinitionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationFieldDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationFieldDefinitionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationFieldDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationFieldDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationFieldDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationFieldDefinition> registrationFieldDefinitions() {
        Function<DescribeRegistrationFieldDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationFieldDefinitions() != null) {
                return response.registrationFieldDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationFieldDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationFieldDefinitionsResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationFieldDefinitionsResponse> {
        private DescribeRegistrationFieldDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationFieldDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationFieldDefinitionsResponse> nextPage(DescribeRegistrationFieldDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationFieldDefinitionsPublisher.this.client.describeRegistrationFieldDefinitions(DescribeRegistrationFieldDefinitionsPublisher.this.firstRequest);
            }
            return DescribeRegistrationFieldDefinitionsPublisher.this.client.describeRegistrationFieldDefinitions((DescribeRegistrationFieldDefinitionsRequest)((Object)DescribeRegistrationFieldDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

