/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountAttributeName {
    ACCOUNT_TIER("ACCOUNT_TIER"),
    DEFAULT_PROTECT_CONFIGURATION_ID("DEFAULT_PROTECT_CONFIGURATION_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountAttributeName> VALUE_MAP;
    private final String value;

    private AccountAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountAttributeName> knownValues() {
        EnumSet<AccountAttributeName> knownValues = EnumSet.allOf(AccountAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountAttributeName.class, AccountAttributeName::toString);
    }
}

