/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventType {
    ALL("ALL"),
    TEXT_ALL("TEXT_ALL"),
    TEXT_SENT("TEXT_SENT"),
    TEXT_PENDING("TEXT_PENDING"),
    TEXT_QUEUED("TEXT_QUEUED"),
    TEXT_SUCCESSFUL("TEXT_SUCCESSFUL"),
    TEXT_DELIVERED("TEXT_DELIVERED"),
    TEXT_INVALID("TEXT_INVALID"),
    TEXT_INVALID_MESSAGE("TEXT_INVALID_MESSAGE"),
    TEXT_UNREACHABLE("TEXT_UNREACHABLE"),
    TEXT_CARRIER_UNREACHABLE("TEXT_CARRIER_UNREACHABLE"),
    TEXT_BLOCKED("TEXT_BLOCKED"),
    TEXT_CARRIER_BLOCKED("TEXT_CARRIER_BLOCKED"),
    TEXT_SPAM("TEXT_SPAM"),
    TEXT_UNKNOWN("TEXT_UNKNOWN"),
    TEXT_TTL_EXPIRED("TEXT_TTL_EXPIRED"),
    VOICE_ALL("VOICE_ALL"),
    VOICE_INITIATED("VOICE_INITIATED"),
    VOICE_RINGING("VOICE_RINGING"),
    VOICE_ANSWERED("VOICE_ANSWERED"),
    VOICE_COMPLETED("VOICE_COMPLETED"),
    VOICE_BUSY("VOICE_BUSY"),
    VOICE_NO_ANSWER("VOICE_NO_ANSWER"),
    VOICE_FAILED("VOICE_FAILED"),
    VOICE_TTL_EXPIRED("VOICE_TTL_EXPIRED"),
    MEDIA_ALL("MEDIA_ALL"),
    MEDIA_PENDING("MEDIA_PENDING"),
    MEDIA_QUEUED("MEDIA_QUEUED"),
    MEDIA_SUCCESSFUL("MEDIA_SUCCESSFUL"),
    MEDIA_DELIVERED("MEDIA_DELIVERED"),
    MEDIA_INVALID("MEDIA_INVALID"),
    MEDIA_INVALID_MESSAGE("MEDIA_INVALID_MESSAGE"),
    MEDIA_UNREACHABLE("MEDIA_UNREACHABLE"),
    MEDIA_CARRIER_UNREACHABLE("MEDIA_CARRIER_UNREACHABLE"),
    MEDIA_BLOCKED("MEDIA_BLOCKED"),
    MEDIA_CARRIER_BLOCKED("MEDIA_CARRIER_BLOCKED"),
    MEDIA_SPAM("MEDIA_SPAM"),
    MEDIA_UNKNOWN("MEDIA_UNKNOWN"),
    MEDIA_TTL_EXPIRED("MEDIA_TTL_EXPIRED"),
    MEDIA_FILE_INACCESSIBLE("MEDIA_FILE_INACCESSIBLE"),
    MEDIA_FILE_TYPE_UNSUPPORTED("MEDIA_FILE_TYPE_UNSUPPORTED"),
    MEDIA_FILE_SIZE_EXCEEDED("MEDIA_FILE_SIZE_EXCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
    }
}

