/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationAttachmentsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeRegistrationAttachmentsResponse> {
    private static final SdkField<List<RegistrationAttachmentsInformation>> REGISTRATION_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationAttachments").getter(DescribeRegistrationAttachmentsResponse.getter(DescribeRegistrationAttachmentsResponse::registrationAttachments)).setter(DescribeRegistrationAttachmentsResponse.setter(Builder::registrationAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationAttachmentsInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationAttachmentsResponse.getter(DescribeRegistrationAttachmentsResponse::nextToken)).setter(DescribeRegistrationAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RegistrationAttachmentsInformation> registrationAttachments;
    private final String nextToken;

    private DescribeRegistrationAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationAttachments = builder.registrationAttachments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRegistrationAttachments() {
        return this.registrationAttachments != null && !(this.registrationAttachments instanceof SdkAutoConstructList);
    }

    public final List<RegistrationAttachmentsInformation> registrationAttachments() {
        return this.registrationAttachments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationAttachments() ? this.registrationAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationAttachmentsResponse)) {
            return false;
        }
        DescribeRegistrationAttachmentsResponse other = (DescribeRegistrationAttachmentsResponse)((Object)obj);
        return this.hasRegistrationAttachments() == other.hasRegistrationAttachments() && Objects.equals(this.registrationAttachments(), other.registrationAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationAttachmentsResponse").add("RegistrationAttachments", this.hasRegistrationAttachments() ? this.registrationAttachments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationAttachments": {
                return Optional.ofNullable(clazz.cast(this.registrationAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<RegistrationAttachmentsInformation> registrationAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationAttachmentsResponse model) {
            super(model);
            this.registrationAttachments(model.registrationAttachments);
            this.nextToken(model.nextToken);
        }

        public final List<RegistrationAttachmentsInformation.Builder> getRegistrationAttachments() {
            List<RegistrationAttachmentsInformation.Builder> result = RegistrationAttachmentsInformationListCopier.copyToBuilder(this.registrationAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationAttachments(Collection<RegistrationAttachmentsInformation.BuilderImpl> registrationAttachments) {
            this.registrationAttachments = RegistrationAttachmentsInformationListCopier.copyFromBuilder(registrationAttachments);
        }

        @Override
        public final Builder registrationAttachments(Collection<RegistrationAttachmentsInformation> registrationAttachments) {
            this.registrationAttachments = RegistrationAttachmentsInformationListCopier.copy(registrationAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAttachments(RegistrationAttachmentsInformation ... registrationAttachments) {
            this.registrationAttachments(Arrays.asList(registrationAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAttachments(Consumer<RegistrationAttachmentsInformation.Builder> ... registrationAttachments) {
            this.registrationAttachments(Stream.of(registrationAttachments).map(c -> (RegistrationAttachmentsInformation)((RegistrationAttachmentsInformation.Builder)RegistrationAttachmentsInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationAttachmentsResponse build() {
            return new DescribeRegistrationAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationAttachmentsResponse> {
        public Builder registrationAttachments(Collection<RegistrationAttachmentsInformation> var1);

        public Builder registrationAttachments(RegistrationAttachmentsInformation ... var1);

        public Builder registrationAttachments(Consumer<RegistrationAttachmentsInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

