/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationTypeFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationTypeFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistrationTypeDefinitionsRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeRegistrationTypeDefinitionsRequest> {
    private static final SdkField<List<String>> REGISTRATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationTypes").getter(DescribeRegistrationTypeDefinitionsRequest.getter(DescribeRegistrationTypeDefinitionsRequest::registrationTypes)).setter(DescribeRegistrationTypeDefinitionsRequest.setter(Builder::registrationTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RegistrationTypeFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeRegistrationTypeDefinitionsRequest.getter(DescribeRegistrationTypeDefinitionsRequest::filters)).setter(DescribeRegistrationTypeDefinitionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationTypeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegistrationTypeDefinitionsRequest.getter(DescribeRegistrationTypeDefinitionsRequest::nextToken)).setter(DescribeRegistrationTypeDefinitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeRegistrationTypeDefinitionsRequest.getter(DescribeRegistrationTypeDefinitionsRequest::maxResults)).setter(DescribeRegistrationTypeDefinitionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPES_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> registrationTypes;
    private final List<RegistrationTypeFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeRegistrationTypeDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.registrationTypes = builder.registrationTypes;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasRegistrationTypes() {
        return this.registrationTypes != null && !(this.registrationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> registrationTypes() {
        return this.registrationTypes;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<RegistrationTypeFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationTypes() ? this.registrationTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationTypeDefinitionsRequest)) {
            return false;
        }
        DescribeRegistrationTypeDefinitionsRequest other = (DescribeRegistrationTypeDefinitionsRequest)((Object)obj);
        return this.hasRegistrationTypes() == other.hasRegistrationTypes() && Objects.equals(this.registrationTypes(), other.registrationTypes()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegistrationTypeDefinitionsRequest").add("RegistrationTypes", this.hasRegistrationTypes() ? this.registrationTypes() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationTypes": {
                return Optional.ofNullable(clazz.cast(this.registrationTypes()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationTypeDefinitionsRequest, T> g) {
        return obj -> g.apply((DescribeRegistrationTypeDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private List<String> registrationTypes = DefaultSdkAutoConstructList.getInstance();
        private List<RegistrationTypeFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationTypeDefinitionsRequest model) {
            super(model);
            this.registrationTypes(model.registrationTypes);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getRegistrationTypes() {
            if (this.registrationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.registrationTypes;
        }

        public final void setRegistrationTypes(Collection<String> registrationTypes) {
            this.registrationTypes = RegistrationTypeListCopier.copy(registrationTypes);
        }

        @Override
        public final Builder registrationTypes(Collection<String> registrationTypes) {
            this.registrationTypes = RegistrationTypeListCopier.copy(registrationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationTypes(String ... registrationTypes) {
            this.registrationTypes(Arrays.asList(registrationTypes));
            return this;
        }

        public final List<RegistrationTypeFilter.Builder> getFilters() {
            List<RegistrationTypeFilter.Builder> result = RegistrationTypeFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<RegistrationTypeFilter.BuilderImpl> filters) {
            this.filters = RegistrationTypeFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<RegistrationTypeFilter> filters) {
            this.filters = RegistrationTypeFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(RegistrationTypeFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<RegistrationTypeFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (RegistrationTypeFilter)((RegistrationTypeFilter.Builder)RegistrationTypeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegistrationTypeDefinitionsRequest build() {
            return new DescribeRegistrationTypeDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistrationTypeDefinitionsRequest> {
        public Builder registrationTypes(Collection<String> var1);

        public Builder registrationTypes(String ... var1);

        public Builder filters(Collection<RegistrationTypeFilter> var1);

        public Builder filters(RegistrationTypeFilter ... var1);

        public Builder filters(Consumer<RegistrationTypeFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

