/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAttachmentsInformation;

public class DescribeRegistrationAttachmentsIterable
implements SdkIterable<DescribeRegistrationAttachmentsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeRegistrationAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistrationAttachmentsIterable(PinpointSmsVoiceV2Client client, DescribeRegistrationAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRegistrationAttachmentsResponseFetcher();
    }

    public Iterator<DescribeRegistrationAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegistrationAttachmentsInformation> registrationAttachments() {
        Function<DescribeRegistrationAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationAttachments() != null) {
                return response.registrationAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistrationAttachmentsResponseFetcher
    implements SyncPageFetcher<DescribeRegistrationAttachmentsResponse> {
        private DescribeRegistrationAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistrationAttachmentsResponse nextPage(DescribeRegistrationAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationAttachmentsIterable.this.client.describeRegistrationAttachments(DescribeRegistrationAttachmentsIterable.this.firstRequest);
            }
            return DescribeRegistrationAttachmentsIterable.this.client.describeRegistrationAttachments((DescribeRegistrationAttachmentsRequest)((Object)DescribeRegistrationAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

